% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plm_methods.R
\name{predict.plm0}
\alias{predict.plm0}
\alias{predict.plm}
\alias{predict.gplm0}
\alias{predict.gplm}
\title{Predict method for discharge rating curves}
\usage{
\method{predict}{plm0}(object, newdata = NULL, wide = FALSE, ...)

\method{predict}{plm}(object, newdata = NULL, wide = FALSE, ...)

\method{predict}{gplm0}(object, newdata = NULL, wide = FALSE, ...)

\method{predict}{gplm}(object, newdata = NULL, wide = FALSE, ...)
}
\arguments{
\item{object}{An object of class "plm0", "plm", "gplm0" or "gplm".}

\item{newdata}{A numeric vector of stage values for which to predict. If omitted, the stage values in the data are used.}

\item{wide}{A logical value denoting whether to produce a wide prediction output. If TRUE, then the output is a table with median prediction values for an equally spaced grid of stages with 1 cm increments, each row containing predictions in a decimeter range of stages.}

\item{...}{Not used in this function}
}
\value{
An object of class "data.frame" with four columns:
  \describe{
    \item{\code{h}}{The stage.}
    \item{\code{lower}}{The 2.5\% posterior predictive quantile.}
    \item{\code{median}}{The 50\% posterior predictive quantile.}
    \item{\code{upper}}{The 97.5\% posterior predictive quantile.}
  }
  If wide=TRUE, a matrix as described above (see wide parameter) is returned.
}
\description{
Predict the discharge for given stage values based on a discharge rating curve model object.
}
\section{Functions}{
\itemize{
\item \code{predict(plm0)}: Predict method for plm0

\item \code{predict(plm)}: Predict method for plm

\item \code{predict(gplm0)}: Predict method for gplm0

\item \code{predict(gplm)}: Predict method for gplm

}}
\examples{
\donttest{
data(krokfors)
set.seed(1)
plm0.fit <- plm0(formula=Q~W,data=krokfors,h_max=10,num_cores=2)
#predict rating curve on a equally 10 cm spaced grid from 9 to 10 meters
predict(plm0.fit,newdata=seq(9,10,by=0.1))
}
}
\seealso{
\code{\link{plm0}}, \code{\link{plm}}, \code{\link{gplm0}} and \code{\link{gplm}} for fitting a discharge rating curve and \code{\link{summary.plm0}}, \code{\link{summary.plm}}, \code{\link{summary.gplm0}} and \code{\link{summary.gplm}} for summaries. It is also useful to look at \code{\link{plot.plm0}}, \code{\link{plot.plm}}, \code{\link{plot.gplm0}} and \code{\link{plot.gplm}} to help visualize all aspects of the fitted discharge rating curve. Additionally, \code{\link{spread_draws}} and \code{\link{spread_draws}} help working directly with the MCMC samples.
}
