% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_barchart.R
\name{visualize_barchart}
\alias{visualize_barchart}
\title{Visualize BERTopic Bar Chart}
\usage{
visualize_barchart(
  model,
  filename = "topics_topwords_interactive_barchart",
  open_file = FALSE
)
}
\arguments{
\item{model}{A BERTopic model object. Must be passed from the calling environment.}

\item{filename}{A character string specifying the name of the HTML file to save the bar chart.
Default is "topics_topwords_interactive_barchart".
The \code{.html} extension is added automatically if not provided.}

\item{open_file}{Logical. If TRUE, opens the HTML file after saving. Default is FALSE.}
}
\value{
Displays the interactive bar chart within the R environment and saves it as an HTML file.
}
\description{
This function visualizes the topics of a BERTopic model using Plotly and saves the output
as an interactive HTML file. It checks for required Python modules and allows for custom file naming.
}
\examples{
\donttest{
if (exists("topic_model")) {
  visualize_barchart(model = topic_model, filename = "custom_barchart",
                     open_file = TRUE)
} else {
  message("No topic_model found. Please train or load a model first.")
}
}
}

