% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confounds.R
\name{confound_strategy}
\alias{confound_strategy}
\title{Confound denoising strategies}
\usage{
confound_strategy(
  name = NULL,
  pca_vars = NULL,
  raw_vars = NULL,
  perc_var = -1,
  npcs = -1
)
}
\arguments{
\item{name}{Character. Name of a predefined strategy (see above), or
\code{NULL} for a custom strategy.}

\item{pca_vars}{Character vector of confound names/wildcards to include in
PCA reduction. Ignored when \code{name} is specified.}

\item{raw_vars}{Character vector of confound names/wildcards to keep without
reduction. Ignored when \code{name} is specified.}

\item{perc_var}{Numeric. Percentage of variance to retain from PCA (default
-1, meaning use \code{npcs} instead).}

\item{npcs}{Integer. Number of PCs to retain (default -1, meaning use
\code{perc_var} instead).}
}
\value{
A \code{confound_strategy} object (S3 class) that can be passed as
the \code{cvars} argument to \code{read_confounds()}.
}
\description{
Creates a structured confound strategy object that specifies which variables
to reduce via PCA and which to keep as-is. Pass the result directly to
\code{read_confounds(..., cvars = confound_strategy(...))}.
}
\details{
When a strategy is passed to \code{read_confounds}, the function:
\enumerate{
\item Selects the \code{pca_vars} columns and reduces them via PCA
(retaining \code{perc_var}\\% of variance or \code{npcs} components).
\item Selects the \code{raw_vars} columns and keeps them unchanged.
\item Column-binds the PCA scores with the raw columns.
}

Available named strategies:
\describe{
\item{\code{"pcabasic80"}}{PCA over motion24 + aCompCor + tCompCor + CSF +
white matter, retaining 80\\% variance.
Discrete cosine regressors are appended un-reduced.}
}
}
\examples{
# Named strategy
confound_strategy("pcabasic80")

# Custom strategy: PCA motion + compcor to 5 PCs, keep cosine regressors
confound_strategy(
  pca_vars = c(confound_set("motion24"), confound_set("compcor")),
  raw_vars = confound_set("cosine"),
  npcs = 5
)
}
