% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R
\name{parse}
\alias{parse}
\title{Parse a file-name into BIDS components}
\usage{
parse(x, fname, ...)
}
\arguments{
\item{x}{the parser object to use for parsing}

\item{fname}{the string (filename) to parse}

\item{...}{extra args passed to methods}
}
\value{
A parsed representation of the BIDS filename, typically a list with extracted components
}
\description{
This generic function parses a BIDS filename into its component parts.
It uses a parser combinator approach to match the filename against known BIDS patterns
and extract relevant metadata such as subject ID, session, task, run, and modality.
}
\examples{
# Parse an anatomical file
parser <- anat_parser()
parse(parser, "sub-01_T1w.nii.gz")

# Parse a functional file
parser <- func_parser()
parse(parser, "sub-01_task-rest_run-01_bold.nii.gz")

# Use the generic BIDS parser
parser <- bids_parser()
parse(parser, "sub-01_ses-pre_task-rest_run-01_bold.nii.gz")
}
