% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_classes.R
\name{new_data_story}
\alias{new_data_story}
\title{Create a data story object}
\usage{
new_data_story(
  hook = NULL,
  context = NULL,
  tension = NULL,
  resolution = NULL,
  ...
)
}
\arguments{
\item{hook}{Character string for the story hook (attention-grabbing opening)}

\item{context}{Character string describing the data context}

\item{tension}{Character string describing the problem or tension}

\item{resolution}{Character string describing the resolution or next steps}

\item{...}{Optional additional fields (audience, metrics, visual_approach, etc.)}
}
\value{
A bid_data_story S3 object
}
\description{
Creates a structured data story object for use in bid_interpret() and other
bidux functions. Uses a flat API with hook, context, tension, and resolution
fields to structure your data narrative.
}
\examples{
# Basic usage
story <- new_data_story(
  hook = "User engagement is declining",
  context = "Our dashboard usage has dropped 30\% this quarter",
  tension = "We don't know if it's UX issues or changing user needs",
  resolution = "Analyze telemetry to identify friction points"
)

# With optional fields
story_detailed <- new_data_story(
  hook = "Revenue dashboards are underutilized",
  context = "Only 40\% of sales team uses the new revenue dashboard",
  tension = "Critical metrics are being missed",
  resolution = "Redesign with behavioral science principles",
  audience = "Sales team",
  metrics = "adoption_rate, time_to_insight"
)

}
