% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-utils.R
\name{generateViridisColorScale}
\alias{generateViridisColorScale}
\title{Generate Scaled Viridis Color Palette for Rate Parameters}
\usage{
generateViridisColorScale(params)
}
\arguments{
\item{params}{A named numeric vector of parameter values (e.g., rates). The names will be
preserved and used to label the resulting color mapping.}
}
\value{
A named list with two elements:
\describe{
\item{\code{NamedColors}}{A named character vector of hex color codes, with names
corresponding to the input parameter names, ordered by increasing parameter value.}
\item{\code{ParamColorMapping}}{A named numeric vector of the sorted parameter values,
maintaining the same order and names as \code{NamedColors}.}
}
}
\description{
Creates a named color mapping for a set of numeric parameters (e.g., evolutionary rates)
using the \pkg{viridis} color palette. Parameters are first sorted in ascending order and
normalized to the range [0, 1], then mapped to evenly spaced viridis colors for
intuitive visualization.
}
\details{
This function is useful for plotting results where parameters should be visually
distinguished based on their magnitude (e.g., rate shifts across a phylogeny).
By using the perceptually uniform viridis palette, it avoids misleading color
interpretations common with rainbow scales.
}
\examples{
if (requireNamespace("viridis", quietly = TRUE)) {
  library(viridis)
  set.seed(1)
  rates <- c(A = 0.1, B = 0.5, C = 0.9)
  color_scale <- generateViridisColorScale(rates)

  # View the color assignments
  color_scale$NamedColors

  # Plot with colors
  barplot(color_scale$ParamColorMapping,
          col = color_scale$NamedColors,
          main = "Rates with Viridis Colors")
}

}
\seealso{
\code{\link[viridis:reexports]{viridis::viridis()}} for details on the color palette.
}
