% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_plots.R
\name{pca_plot_correlation_circle}
\alias{pca_plot_correlation_circle}
\title{Plot a PCA correlation circle}
\usage{
pca_plot_correlation_circle(
  correlations,
  components = c(1L, 2L),
  labels = NULL,
  draw = TRUE,
  ...
)
}
\arguments{
\item{correlations}{Matrix or \code{bigmemory::big.matrix} containing variable
correlations, typically produced by \code{\link[=pca_variable_correlations]{pca_variable_correlations()}}.}

\item{components}{Length-two integer vector specifying the principal
components to display.}

\item{labels}{Optional character vector specifying the labels to display for
each variable. When \code{NULL}, the row names of \code{correlations} are used when
available.}

\item{draw}{Logical; set to \code{FALSE} to return the prepared coordinates
without plotting.}

\item{...}{Additional graphical parameters passed to \code{\link[graphics:plot.default]{graphics::plot()}}.}
}
\value{
A data frame with \code{variable}, \code{PCx}, and \code{PCy} columns representing the
projected correlations, where \code{PCx}/\code{PCy} correspond to the requested
component indices. The data frame is returned invisibly.
}
\description{
Visualises the correlation between each variable and a pair of principal
components. The variables are projected onto the unit circle, where points
near the perimeter indicate strong correlation with the selected components.
}
