% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_interface.R
\name{pca_stream_bigmatrix}
\alias{pca_stream_bigmatrix}
\alias{pca_spca_stream_bigmatrix}
\alias{pca_scores_stream_bigmatrix}
\alias{pca_variable_loadings_stream_bigmatrix}
\alias{pca_variable_correlations_stream_bigmatrix}
\alias{pca_variable_contributions_stream_bigmatrix}
\title{Streaming big.matrix PCA helpers}
\usage{
pca_spca_stream_bigmatrix(
  xpMat,
  xpRotation = NULL,
  center = TRUE,
  scale = FALSE,
  ncomp = -1L,
  block_size = 2048L,
  max_iter = 50L,
  tol = 1e-04,
  seed = NULL,
  return_scores = FALSE,
  verbose = FALSE
)

pca_scores_stream_bigmatrix(
  xpMat,
  xpDest,
  rotation,
  center,
  scale,
  ncomp = -1L,
  block_size = 1024L
)

pca_variable_loadings_stream_bigmatrix(xpRotation, sdev, xpDest)

pca_variable_correlations_stream_bigmatrix(
  xpRotation,
  sdev,
  column_sd,
  scale = NULL,
  xpDest
)

pca_variable_contributions_stream_bigmatrix(xpLoadings, xpDest)
}
\arguments{
\item{xpMat}{Either a \code{\link[bigmemory:big.matrix]{bigmemory::big.matrix}} or an external pointer such
as \code{mat@address} that references the source \code{big.matrix}.}

\item{xpRotation}{For \code{pca_variable_correlations_stream_bigmatrix()}, a
\code{bigmemory::big.matrix} or external pointer containing the rotation matrix
to stream from.}

\item{center}{For \code{pca_scores_bigmatrix()}, a numeric vector of column means
(optional).}

\item{scale}{Optional numeric vector of scaling factors returned by
\code{\link[=pca_stream_bigmatrix]{pca_stream_bigmatrix()}} or \code{\link[=pca_bigmatrix]{pca_bigmatrix()}}. When supplied, correlations
are reported on the scaled data without dividing by \code{column_sd}.}

\item{ncomp}{Number of components to retain. Use a non-positive value to keep
all components returned by the decomposition.}

\item{block_size}{Number of rows to process per block when streaming data
through BLAS kernels. Larger values improve throughput at the cost of
additional memory.}

\item{max_iter}{Maximum number of block power iterations.}

\item{tol}{Convergence tolerance applied to the Frobenius norm of the
difference between successive subspace projectors.}

\item{seed}{Optional integer seed used to initialise the random starting
basis.}

\item{return_scores}{Logical; when \code{TRUE}, principal component scores are
computed in a final streaming pass over the data.}

\item{verbose}{Logical; when \code{TRUE}, diagnostic messages describing the
iteration progress are emitted.}

\item{xpDest}{Either a \code{big.matrix} or external pointer referencing the
destination \code{big.matrix} that stores the computed quantity.}

\item{rotation}{A rotation matrix such as the \code{rotation} element returned by
\code{\link[=pca_bigmatrix]{pca_bigmatrix()}}.}

\item{sdev}{A numeric vector of component standard deviations, typically the
\code{sdev} element from \code{\link[=pca_bigmatrix]{pca_bigmatrix()}}.}

\item{column_sd}{A numeric vector of variable standard deviations used to
scale the correlations when the PCA was performed on unscaled data.}

\item{xpLoadings}{For \code{pca_variable_contributions_stream_bigmatrix()}, the
loadings matrix supplied as a \code{big.matrix} or external pointer.}
}
\value{
For \code{pca_stream_bigmatrix()}, the same \code{bigpca} object as
\code{\link[=pca_bigmatrix]{pca_bigmatrix()}} with the
addition of a \code{rotation_stream_bigmatrix} element referencing the populated
\code{big.matrix} when \code{xpRotation} is supplied. For
\code{pca_spca_stream_bigmatrix()}, the same scalable PCA structure as
\code{\link[=pca_spca]{pca_spca()}} with the optional pointer populated when provided.

The external pointer supplied in \code{xpDest}, invisibly.
}
\description{
Variants of the PCA helpers that stream results directly into
\code{bigmemory::big.matrix} objects, enabling file-backed workflows without
materialising dense R matrices.
}
\section{Functions}{
\itemize{
\item \code{pca_scores_stream_bigmatrix()}: Stream PCA scores into a destination
big.matrix.

\item \code{pca_variable_loadings_stream_bigmatrix()}: Populate big.matrix objects with derived variable
diagnostics.

\item \code{pca_variable_correlations_stream_bigmatrix()}: Stream variable correlations into a
destination big.matrix.

\item \code{pca_variable_contributions_stream_bigmatrix()}: Stream variable contributions into a
destination big.matrix.

}}
\examples{
\dontshow{if (requireNamespace("bigmemory", quietly = TRUE)) withAutoprint(\{ # examplesIf}
set.seed(456)
mat <- bigmemory::as.big.matrix(matrix(rnorm(30), nrow = 6))
ncomp <- 2
rotation_store <- bigmemory::big.matrix(ncol(mat), ncomp, type = "double")
pca_stream <- pca_stream_bigmatrix(mat, xpRotation = rotation_store, ncomp = ncomp)
score_store <- bigmemory::big.matrix(nrow(mat), ncomp, type = "double")
pca_scores_stream_bigmatrix(
    mat,
    score_store,
    pca_stream$rotation,
    pca_stream$center,
    pca_stream$scale,
    ncomp = ncomp
)
loadings_store <- bigmemory::big.matrix(ncol(mat), ncomp, type = "double")
pca_variable_loadings_stream_bigmatrix(
    pca_stream$rotation_stream_bigmatrix,
    pca_stream$sdev,
    loadings_store
)
correlation_store <- bigmemory::big.matrix(ncol(mat), ncomp, type = "double")
pca_variable_correlations_stream_bigmatrix(
    pca_stream$rotation_stream_bigmatrix,
    pca_stream$sdev,
    pca_stream$column_sd,
    pca_stream$scale,
    correlation_store
)
contribution_store <- bigmemory::big.matrix(ncol(mat), ncomp, type = "double")
pca_variable_contributions_stream_bigmatrix(
    loadings_store,
    contribution_store
)
\dontshow{\}) # examplesIf}
}
