% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_irls_binomial}
\alias{cpp_irls_binomial}
\title{Fast IRLS for binomial logit with class weights}
\usage{
cpp_irls_binomial(TT, ybin, w_class = NULL, maxit = 50L, tol = 1e-08)
}
\arguments{
\item{TT}{n x A numeric matrix of latent scores (no intercept column)}

\item{ybin}{integer vector of \{0,1\} labels (length n)}

\item{w_class}{optional length-2 numeric vector: weights for classes c( w0, w1 )}

\item{maxit}{max IRLS iterations}

\item{tol}{relative tolerance on parameter change}
}
\value{
list(beta = A-vector, b = scalar intercept, fitted = n-vector,
iter = integer, converged = logical)
}
\description{
Fast IRLS for binomial logit with class weights
}
