% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bq-param.R
\name{bq_param}
\alias{bq_param}
\alias{bq_param_scalar}
\alias{bq_param_array}
\title{Explicitly define query parameters}
\usage{
bq_param(value, type = NULL, name = NULL)

bq_param_scalar(value, type = NULL, name = NULL)

bq_param_array(value, type = NULL, name = NULL)
}
\arguments{
\item{value}{vector of parameter values}

\item{type}{BigQuery type of the parameter}

\item{name}{name of the parameter in the query, omitting the \code{@}}
}
\description{
By default, bigrquery will assume vectors of length 1 are scalars,
and longer vectors are arrays. If you need to pass a length-1 array,
you'll need to explicitly use \code{bq_param_array()}.
}
\examples{
# bq_param() automatically picks scalar vs array based on length
bq_param("a")
bq_param(c("a", "b", "c"))

# use bq_param_array() to create a length-1 array
bq_param_array("a")
}
\keyword{internal}
