% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estinternsp.R
\name{print.output_estinternsp}
\alias{print.output_estinternsp}
\title{Text output describing the posterior distributions}
\usage{
\method{print}{output_estinternsp}(x, ...)
}
\arguments{
\item{x}{Output of the main function \code{\link{estinternsp}}.}

\item{...}{further arguments passed from generic print function.}
}
\value{
Text output summarizing the posterior distributions for each parameter.
}
\description{
Output printing function of interaction neyman-scott process. It prints the estimated values and the posterior confidence intervals for each parameter.
}
\examples{
library(spatstat)
# library(spatstat.geom)
library(fields)
library(mvtnorm)
library(binspp)

# Generate example window
W <- owin(xrange = c(0, 100), yrange = c(0, 50)) # example window (rectangle)
radius = 2
W_dil = dilation.owin(W, radius)
AreaW <- area(W)
AreaMRW <- area(W_dil)

x_left = W$xrange[1]
x_right = W$xrange[2]
y_bottom = W$yrange[1]
y_top = W$yrange[2]

# True parameters
alpha <- 15
omega <- 1.5
kappa <- 0.001
theta1 <- 3
theta2 <- 10

# Generate parents process
CCC <- rpoispp(kappa, win = W_dil)
CC <- t(rbind(CCC$x,CCC$y))
CCdist <- rdist(CC)
r <- binspp::coeff(c(theta1,theta2))
r1 <- r[1]; r2 <- r[2]; t1 <- theta1; t2 <- theta2; t3 <- 0.5; R <- 0;
rho0sum <- rep(0,dim(CC)[1])                # row sum of rho matrix
res <- binspp::pCClik2(c(theta1,theta2), CC)
rho0sum <- res$rhosum
likelihoodprev <- res$likelihood

# this is just for example, for a real estimate
# use value of at least niter = 10000
CC.true <- AuxVarGen(kappa, c(theta1,theta2), likelihoodprev, rho0sum, CC,
    AreaMRW, W_dil, 100)

# Generate offsprings given parents
gaus <- function(n, omega) {
  matrix(rnorm(2 * n, mean=0, sd=omega), ncol=2)
}
parents <- ppp(CC.true[[1]][,1],CC.true[[1]][,2],window=W)
np <- npoints(parents)

csize <- qpois(runif(np, min = dpois(0, alpha)), alpha)
noff <- sum(csize)
xparent <- parents$x
yparent <- parents$y
x0 <- rep.int(xparent, csize)
y0 <- rep.int(yparent, csize)
dd <- gaus(noff, omega)
xy <- xy.coords(dd)
dx <- xy$x; dy <- xy$y

xoff <- x0 + dx; yoff <- y0 + dy
result <- ppp(xoff, yoff, window = W_dil, check = FALSE, marks = NULL)
X <- cbind(result$x,result$y) # Generate example data

# this is just for example, for a real estimate
# use values of at least NStep = 20000 and BurnIn = 5000
control = list(NStep = 50, BurnIn = 25, SamplingFreq = 10,
   Prior_alpha_mean = 15, Prior_alpha_SD = 2, alpha_LB = 10, alpha_UB = 20,
   Prior_omega_mean = 1.5, Prior_omega_SD = 0.2, omega_LB = 1, omega_UB = 2,
   Prior_kappa_mean = 0.001, Prior_kappa_SD = 0.0001, kappa_LB = 0.0005,
                             kappa_UB = 0.002,
   Prior_theta1_mean = 3, Prior_theta1_SD = 0.2, theta1_LB = 2.5,
                             theta1_UB = 3.5,
   Prior_theta2_mean = 10, Prior_theta2_SD = 1, theta2_LB = 8,
                             theta2_UB = 12)

Output = estinternsp(X, control,
                     x_left, x_right, y_bottom, y_top,
                     W_dil,
                     AreaW, AreaMRW, radius)
print(Output)

}
\seealso{
\code{\link{estinternsp}}
}
