% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sniff_components.R
\name{sniff_components}
\alias{sniff_components}
\title{Identify and Analyze Network Components}
\usage{
sniff_components(net)
}
\arguments{
\item{net}{A network object (tbl_graph or igraph) generated by \code{sniff_network()}}
}
\value{
A list with two elements:
\describe{
\item{components}{A tibble with component statistics containing:
\itemize{
\item \code{component}: Component identifier (e.g., "c1")
\item \code{quantity_publications}: Number of publications in component
\item \code{average_age}: Mean publication year of component
}
}
\item{network}{The input network with added component labels}
}
}
\description{
Detects connected components in a citation network and computes summary statistics
for each component. Returns both the component information and an updated network
with component labels.
}
\examples{
\dontrun{
# Create a network first
data <- read_wos("savedrecs.txt")
net <- sniff_network(data)

# Analyze components
result <- sniff_components(net)

# Access component information
result$components

# Get network with component labels
component_net <- result$network
}
}
