% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sniff_groups_keywords.R
\name{sniff_groups_keywords}
\alias{sniff_groups_keywords}
\title{Extract representative keywords from grouped nodes}
\usage{
sniff_groups_keywords(net_groups, n_terms = 15, min_freq = 1, sep = ";")
}
\arguments{
\item{net_groups}{A list containing a \code{network} component of class \code{tbl_graph},
where each node has at least two attributes: \code{group} and \code{DE}.}

\item{n_terms}{Integer. The number of top terms to return per group, both by frequency and by TF-IDF. Default is 15.}

\item{min_freq}{Integer. Minimum frequency a term must have in a group to be considered. Default is 2.}

\item{sep}{Character. Separator used in the \code{DE} field to split multiple terms. Default is \code{";"}.}
}
\value{
A tibble with one row per group, containing two columns:
\itemize{
\item \code{term_freq}: the most frequent terms (with raw frequency).
\item \code{term_tfidf}: the most distinctive terms (with TF-IDF scores).
}
}
\description{
This function processes nodes grouped in a network (typically by community detection),
and extracts the most frequent and the most distinctive keywords (using TF-IDF) from
a descriptor field such as keywords or subject terms.
}
\examples{
\dontrun{
# Assuming 'groups' is output from sniff_groups()
groups_keywords <- sniff_groups_keywords(groups)
}
}
