% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.read_te_all}
\alias{.read_te_all}
\title{Read transfer entropy results from CSV files}
\usage{
.read_te_all(dir_csv)
}
\arguments{
\item{dir_csv}{Character scalar; directory where the transfer entropy
CSV files are stored.

The function first looks for \code{"transfer_entropy.csv"}. If present,
it is read and returned. Otherwise it attempts to read:
\itemize{
\item \code{"transfer_entropy_counts.csv"}
\item \code{"transfer_entropy_rates.csv"}
\item \code{"transfer_entropy_binary.csv"}
}
and combines them into a single data frame with a \code{type} column.}
}
\value{
A data frame with transfer entropy results (potentially
combining several types) or \code{NULL} if no files are found.
}
\description{
Helper to load transfer entropy results from a combined CSV file or
from separate per-type files (counts, rates, binary) if the combined
file is not available.
}
\keyword{internal}
