% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align.R
\name{align_sequences}
\alias{align_sequences}
\title{Align DNA Sequences (Pairwise or Multiple)}
\usage{
align_sequences(
  df,
  method = c("pairwise", "msa"),
  pairwise_type = "global",
  msa_method = "ClustalOmega",
  seq_indices = c(1, 2)
)
}
\arguments{
\item{df}{A tibble or data.frame containing at least:
\itemize{
\item \code{sequence}: character vector of DNA sequences
\item \code{accession} (optional): names for each sequence; if present, they will be
used as identifiers in the alignment object.
}}

\item{method}{One of:
\itemize{
\item "pairwise": perform a pairwise alignment between two sequences
\item "msa": perform a multiple sequence alignment on all sequences
}}

\item{pairwise_type}{For pairwise only, alignment type: "global" (Needleman–Wunsch),
"local" (Smith–Waterman), or "overlap".}

\item{msa_method}{For MSA only, method name: "ClustalOmega", "ClustalW", or "Muscle".}

\item{seq_indices}{Integer vector of length 2; indices of the two sequences to align when
\code{method = "pairwise"}. Defaults to \code{c(1,2)}.}
}
\value{
If \code{method="pairwise"}, a list with:
\itemize{
\item \code{alignment}: a \code{PairwiseAlignmentsSingleSubject} object
\item \code{pid}: percent identity (numeric)
If \code{method="msa"}, an object of class \code{MsaDNAMultipleAlignment} or similar.
}
}
\description{
This function takes a tibble with a "sequence" column (and optional "accession" names)
and performs either a pairwise alignment between two sequences or a multiple sequence
alignment (MSA) across all.
}
\examples{
\donttest{
# Pairwise alignment example (requires pwalign package)
if (requireNamespace("pwalign", quietly = TRUE)) {
  data <- data.frame(
    accession = c("seq1", "seq2"),
    sequence  = c("ACGTACGTACGT", "ACGTACGTTTGT"),
    stringsAsFactors = FALSE
  )

  res_pw <- align_sequences(
    df = data,
    method = "pairwise",
    pairwise_type = "global"
  )
  res_pw$pid
}

# Multiple sequence alignment (requires msa package)
if (requireNamespace("msa", quietly = TRUE)) {
  data_msa <- data.frame(
    accession = c("seq1", "seq2", "seq3"),
    sequence = c("ATGCATGC", "ATGCTAGC", "ATGGATGC")
  )
  res_msa <- align_sequences(data_msa, method = "msa", msa_method = "ClustalOmega")
  print(res_msa)
}
}

}
