% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blendsurv.R
\name{blendsurv}
\alias{blendsurv}
\title{Blended survival object}
\usage{
blendsurv(
  obs_Surv,
  ext_Surv,
  blend_interv,
  beta_params = list(alpha = 3, beta = 3),
  times = NULL,
  nsim = 100
)
}
\arguments{
\item{obs_Surv, ext_Surv}{Observed and external data survival curves.
These can come from \pkg{survHE}, \pkg{INLA} or \pkg{flexsurv} fits.}

\item{blend_interv}{Maximum and minimum values for the blending interval.}

\item{beta_params}{coefficients of a beta distribution}

\item{times}{A vector of times for which the survival curves
are to be computed; optional}

\item{nsim}{The number of simulations from the distribution of
the survival curves; default 100}
}
\value{
List of S for observed, external and blended curves.
}
\description{
This is the main function in the \pkg{blendR} package.
Two survival curves are supplied and blended according to
the blending distribution characterised by the blending interval and
the beta distribution parameters.
}
\examples{
\dontshow{if (rlang::is_installed("survHEhmc")) withAutoprint(\{ # examplesIf}

library(survHE)

## trial data
data("TA174_FCR", package = "blendR")

## externally estimated data
data_sim <- ext_surv_sim(t_info = 144,
                         S_info = 0.05,
                         T_max = 180)

obs_Surv <- fit.models(formula = Surv(death_t, death) ~ 1,
                       data = dat_FCR,
                       distr = "exponential",
                       method = "hmc")

ext_Surv <- fit.models(formula = Surv(time, event) ~ 1,
                       data = data_sim,
                       distr = "exponential",
                       method = "hmc")

blend_interv <- list(min = 48, max = 150)
beta_params <- list(alpha = 3, beta = 3)

ble_Surv <- blendsurv(obs_Surv, ext_Surv, blend_interv, beta_params)

plot(ble_Surv)
\dontshow{\}) # examplesIf}
}
