% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_inla_pw.R
\name{fit_inla_pw}
\alias{fit_inla_pw}
\title{Generate survival estimates with a piecewise exponential Cox model (using INLA)}
\usage{
fit_inla_pw(
  inla.formula = inla.surv(death_t, death) ~ -1,
  data,
  cutpoints,
  nsim = 100,
  ...
)
}
\arguments{
\item{inla.formula}{The formula for PEM which must be an \code{inla.surv} object}

\item{data}{A dataframe for survival data with time (\code{death_t}) and
event (\code{death})}

\item{cutpoints}{A sequence of cut points for intervals in the baseline hazard}

\item{nsim}{The number of simulations from posteriors; default 100}

\item{...}{Additional arguments}
}
\value{
INLA object
}
\description{
Generate survival estimates with a piecewise exponential Cox model (using INLA)
}
\examples{
\donttest{
 if (requireNamespace("INLA", quietly = TRUE)) {
  data("TA174_FCR", package = "blendR")
  head(dat_FCR)
  obs_Surv <- fit_inla_pw(data = dat_FCR, cutpoints = seq(0, 180, by = 5))
 }
}

}
