% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block-server.R
\name{block_server}
\alias{block_server}
\alias{block_server.block}
\alias{expr_server}
\alias{block_eval}
\alias{eval_env}
\alias{block_eval_trigger}
\alias{block_render_trigger}
\title{Block server}
\usage{
block_server(id, x, data = list(), ...)

\method{block_server}{block}(
  id,
  x,
  data = list(),
  block_id = id,
  edit_block = NULL,
  board = reactiveValues(),
  update = reactiveVal(),
  ...
)

expr_server(x, data, ...)

block_eval(x, expr, env, ...)

eval_env(data)

block_eval_trigger(x, session = get_session())

block_render_trigger(x, session = get_session())
}
\arguments{
\item{id}{Namespace ID}

\item{x}{Object for which to generate a \code{\link[shiny:moduleServer]{shiny::moduleServer()}}}

\item{data}{Input data (list of reactives)}

\item{...}{Generic consistency}

\item{block_id}{Block ID}

\item{edit_block}{Block edit plugin}

\item{board}{Reactive values object containing board information}

\item{update}{Reactive value object to initiate board updates}

\item{expr}{Quoted expression to evaluate in the context of \code{data}}

\item{env}{Environment in which to evaluate \code{expr}}

\item{session}{Shiny session object}
}
\value{
Both \code{block_server()} and \code{expr_server()} return shiny server module
(i.e. a call to \code{\link[shiny:moduleServer]{shiny::moduleServer()}}), while \code{block_eval()} evaluates
an interpolated (w.r.t. block "user" inputs) block expression in the context
of block data inputs.
}
\description{
A block is represented by several (nested) shiny modules and the top level
module is created using the \code{block_server()} generic. S3 dispatch is offered
as a way to add flexibility, but in most cases the default method for the
\code{block} class should suffice at top level. Further entry points for
customization are offered by the generics \code{expr_server()} and \code{block_eval()},
which are responsible for initializing the block "expression" module (i.e.
the block server function passed in \code{\link[=new_block]{new_block()}}) and block evaluation
(evaluating the interpolated expression in the context of input data),
respectively.
}
\details{
The module returned from \code{block_server()}, at least in the default
implementation, provides much of the essential but block-type agnostic
functionality, including data input validation (if available), instantiation
of the block expression server (handling the block-specific functionality,
i.e. block user inputs and expression), and instantiation of the
\code{edit_block} module (if passed from the parent scope).

A block is considered ready for evaluation whenever input data is available
that satisfies validation (\code{\link[=validate_data_inputs]{validate_data_inputs()}}) and nonempty state
values are available (unless otherwise instructed via \code{allow_empty_state}
in \code{\link[=new_block]{new_block()}}). Conditions raised during validation and evaluation are
caught and returned in order to be surfaced to the app user.

Block-level user inputs (provided by the expression module) are separated
from output, the behavior of which can be customized via the
\code{\link[=block_output]{block_output()}} generic. The \code{\link[=block_ui]{block_ui()}} generic can then be used to
control rendering of outputs.
}
