% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet-block.R
\name{new_facet_block}
\alias{new_facet_block}
\title{Facet Block}
\usage{
new_facet_block(
  facet_type = "wrap",
  facets = character(),
  rows = character(),
  cols = character(),
  ncol = character(),
  nrow = character(),
  scales = "fixed",
  labeller = "label_value",
  dir = "h",
  space = "fixed",
  ...
)
}
\arguments{
\item{facet_type}{Type of faceting: "wrap" or "grid" (default: "wrap")}

\item{facets}{Column(s) to facet by for facet_wrap (character vector)}

\item{rows}{Column(s) for row facets in facet_grid (character vector)}

\item{cols}{Column(s) for column facets in facet_grid (character vector)}

\item{ncol}{Number of columns for facet_wrap (default: NULL for auto)}

\item{nrow}{Number of rows for facet_wrap (default: NULL for auto)}

\item{scales}{Scale behavior: "fixed", "free", "free_x", "free_y"
(default: "fixed")}

\item{labeller}{Labeller function: "label_value", "label_both",
"label_parsed" (default: "label_value")}

\item{dir}{Direction for facet_wrap: "h" (horizontal) or "v" (vertical)
(default: "h")}

\item{space}{Space behavior for facet_grid: "fixed", "free_x", "free_y"
(default: "fixed")}

\item{...}{Forwarded to \code{\link[=new_ggplot_transform_block]{new_ggplot_transform_block()}}}
}
\value{
A ggplot transform block object of class \code{facet_block}.
}
\description{
Applies faceting to a ggplot object using facet_wrap() or facet_grid().
Accepts a single ggplot input and adds faceting based on data columns.
}
\examples{
# Create a facet wrap block
new_facet_block(facet_type = "wrap", facets = "cyl")

# Create a facet grid block
new_facet_block(facet_type = "grid", rows = "cyl", cols = "gear")

if (interactive()) {
  library(blockr.core)
  # Facet block requires a ggplot input
  serve(new_facet_block())
}

}
