% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{new_read_block}
\alias{new_read_block}
\title{Unified file reading block}
\usage{
new_read_block(
  path = character(),
  source = "upload",
  combine = "auto",
  args = list(),
  ...
)
}
\arguments{
\item{path}{Character vector of file paths to pre-load. When provided,
automatically switches to "path" mode regardless of the source parameter.}

\item{source}{Either "upload" for file upload widget, "path" for file browser,
or "url" for URL download. Default: "upload". Automatically set based on path parameter.}

\item{combine}{Strategy for combining multiple files: "auto", "rbind", "cbind", "first"}

\item{args}{Named list of format-specific reading parameters. Only specify values
that differ from defaults. Available parameters:
\itemize{
\item \strong{For CSV files:} \code{sep} (default: ","), \code{quote} (default: '"'),
\code{encoding} (default: "UTF-8"), \code{skip} (default: 0),
\code{n_max} (default: Inf), \code{col_names} (default: TRUE)
\item \strong{For Excel files:} \code{sheet} (default: NULL), \code{range} (default: NULL),
\code{skip} (default: 0), \code{n_max} (default: Inf), \code{col_names} (default: TRUE)
}}

\item{...}{Forwarded to \code{\link[blockr.core:new_data_block]{blockr.core::new_data_block()}}}
}
\value{
A blockr data block that reads file(s) and returns a data.frame.
}
\description{
A single block for reading files in various formats with smart UI that adapts
based on detected file type. Supports "From Browser" (upload) and "From Server"
(browse) modes with persistent storage for uploaded files.
}
\details{
\subsection{File Handling Modes}{

The block supports three modes:

\strong{From Browser mode} (upload):
\itemize{
\item User uploads files from their computer via the browser
\item Files are copied to persistent storage directory (upload_path)
\item State stores permanent file paths
\item Works across R sessions with state restoration
}

\strong{From Server mode} (path):
\itemize{
\item User picks files that already exist on the server
\item No file copying, reads directly from original location
\item State stores selected file paths
\item When running locally, this is your computer's file system
}

\strong{URL mode:}
\itemize{
\item User provides a URL to a data file
\item File is downloaded to temporary location each time
\item Always fetches fresh data from URL
\item State stores the URL (not file path)
}
}

\subsection{Smart Adaptive UI}{

After file selection, the UI detects file type and shows relevant options:
\itemize{
\item \strong{CSV/TSV:} Delimiter, quote character, encoding options
\item \strong{Excel:} Sheet selection, cell range
\item \strong{Other formats:} Minimal or no options (handled automatically)
}
}

\subsection{Multi-file Support}{

When multiple files are selected:
\itemize{
\item \strong{"auto"}: Attempts rbind, falls back to first file if incompatible
\item \strong{"rbind"}: Row-binds files (requires same columns)
\item \strong{"cbind"}: Column-binds files (requires same row count)
\item \strong{"first"}: Uses only the first file
}
}
}
\section{Configuration}{

The following settings are retrieved from options and not stored in block state:
\itemize{
\item \strong{volumes}: File browser mount points. Set via \code{options(blockr.volumes = c(name = "path"))}
or environment variable \code{BLOCKR_VOLUMES}. Default: \code{c(temp = tempdir())}
\item \strong{upload_path}: Directory for persistent file storage. Set via
\code{options(blockr.upload_path = "/path")} or environment variable \code{BLOCKR_UPLOAD_PATH}.
Default: \code{rappdirs::user_data_dir("blockr")}
}
}

\examples{
# Create a read block for a CSV file
csv_file <- tempfile(fileext = ".csv")
write.csv(mtcars[1:5, ], csv_file, row.names = FALSE)
block <- new_read_block(path = csv_file)
block

# With custom CSV parameters
block <- new_read_block(
  path = csv_file,
  args = list(n_max = 3)
)

if (interactive()) {
  # Launch interactive app
  serve(new_read_block())
}

}
