% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_list.R
\name{as.data.frame.sim_list}
\alias{as.data.frame.sim_list}
\title{Coerce to a Data Frame}
\usage{
\method{as.data.frame}{sim_list}(x, ..., sim_column = "sim")
}
\arguments{
\item{x}{a collection of spatial interaction models, an object of class
\code{sim_list}}

\item{...}{additional parameters (not used currently)}

\item{sim_column}{the name of the \code{sim_list} column (default \code{"sim"})}
}
\value{
a data frame
}
\description{
This function creates a data frame with a single column storing its
collection of spatial interaction models. The default name of the column
is \code{"sim"} (can be modified using the \code{sim_column} parameter). An more
flexible alternative is provided by the \code{\link[=sim_df]{sim_df()}} function.
}
\examples{
distances <- french_cities_distances[1:15, 1:15] / 1000 ## convert to km
production <- log(french_cities$population[1:15])
attractiveness <- log(french_cities$area[1:15])
all_flows_log <- grid_blvim(
  distances, production, c(1.1, 1.25, 1.5),
  c(1, 2, 3, 4) / 500, attractiveness,
  epsilon = 0.1,
  bipartite = FALSE,
  iter_max = 750
)
as.data.frame(all_flows_log, sim_column = "log flows")
}
\seealso{
\code{\link[=sim_df]{sim_df()}}
}
