% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_list_common.R
\name{costs.sim_list}
\alias{costs.sim_list}
\title{Extract the common cost matrix from a collection of spatial interaction models}
\usage{
\method{costs}{sim_list}(sim, ...)
}
\arguments{
\item{sim}{a collection of spatial interaction models, an object of class
\code{sim_list}}

\item{...}{additional parameters}
}
\value{
the cost matrix
}
\description{
Extract the common cost matrix from a collection of spatial interaction models
}
\examples{
distances <- french_cities_distances[1:10, 1:10] / 1000 ## convert to km
production <- rep(1, 10)
attractiveness <- log(french_cities$area[1:10])
all_flows <- grid_blvim(
  distances, production, c(1.25, 1.5),
  c(1, 2, 3, 4) / 500, attractiveness
)
## should be TRUE
identical(distances, costs(all_flows))

}
\seealso{
\code{\link[=costs]{costs()}}, \code{\link[=grid_blvim]{grid_blvim()}}
}
