% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_names.R
\name{destination_names}
\alias{destination_names}
\alias{destination_names<-}
\title{Names of destination locations in a spatial interaction model}
\usage{
destination_names(sim)

destination_names(sim) <- value
}
\arguments{
\item{sim}{a spatial interaction model object (an object of class \code{sim}) or a
collection of spatial interaction  models (an object of class \code{sim_list})}

\item{value}{a character vector of length equal to the number of destination
locations, or \code{NULL} (vectors of adapted length are converted to character
vectors)}
}
\value{
for \code{destination_names} \code{NULL} or a character vector with one name
per destination locations in the model. for \verb{destination_names<-} the
modified \code{sim} object or \code{sim_list} object.
}
\description{
Functions to get or set the names of the destination locations in a spatial
interaction model (or in a collection of spatial interaction models).
}
\examples{
distances <- french_cities_distances[1:10, 1:10]
production <- rep(1, 10)
attractiveness <- rep(1, 10)
## the row/column names of the cost matrix are used for the location
model <- static_blvim(distances, production, 1.5, 1 / 250000, attractiveness)
destination_names(model)
destination_names(model) <- french_cities$name[1:10]
destination_names(model)
}
\seealso{
\code{\link[=location_names]{location_names()}}, \code{\link[=origin_names]{origin_names()}}
}
