% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{french_cities}
\alias{french_cities}
\title{French cities}
\format{
A \code{data.frame} with 121 rows and 9 columns
\describe{
\item{id}{The INSEE code of the city according to the official geographical
code of 2025 (OGC)}
\item{name}{The name of the city}
\item{department}{The code of the department of the city in the OGC (see \link{french_departments})}
\item{region}{The code of the region of the city in the OGC (see \link{french_regions})}
\item{population}{The population of the city in 2022}
\item{area}{Area of the city in squared kilometers}
\item{th_latitude}{The latitude of the of town hall the city (epsg:4326)}
\item{th_longitude}{The longitude of the town hall of the city (epsg:4326)}
\item{center_latitude}{The latitude of the centre of the city (epsg:4326)}
\item{center_longitude}{The longitude of the centre of the city (epsg:4326)}
}
}
\source{
INSEE Population census - Main extraction (2022)
\url{https://catalogue-donnees.insee.fr/en/catalogue/recherche/DS_RP_POPULATION_PRINC}

INSEE Official Geographical Code (2025)
\url{https://www.data.gouv.fr/datasets/code-officiel-geographique-cog/}
\url{https://www.data.gouv.fr/api/1/datasets/r/91a95bee-c7c8-45f9-a8aa-f14cc4697545}

Geo API (2025) \url{https://geo.api.gouv.fr/}
}
\usage{
french_cities
}
\description{
French cities with 50,000 inhabitants or more.
}
\details{
This data set describes all Metropolitan France cities with 50,000 or more
inhabitants in 2022, excluding Corsican cities. It contains 121 cities
described by 8 variables. The data frame is sorted in decreasing population
order, making it straightforward to select the most populated cities. The
same order is used for rows and columns in distance matrices
\link{french_cities_distances} and \link{french_cities_times}.

The population and administrative information was collected from the INSEE
open data in November 2025. These data are distributed under the
\href{https://www.etalab.gouv.fr/wp-content/uploads/2014/05/Open_Licence.pdf}{French "Open Licence"}.
Geographical coordinates and areas have been obtained from the
\href{https://geo.api.gouv.fr/}{Geo API} in November 2025 and are also
available under the French "Open Licence".
}
\seealso{
\link{french_departments}, \link{french_regions}, \link{french_cities_distances} and
\link{french_cities_times}
}
\keyword{datasets}
