% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_list_stats.R
\name{quantile.sim_list}
\alias{quantile.sim_list}
\title{Compute quantiles of the flows in a collection of spatial interaction models}
\usage{
\method{quantile}{sim_list}(
  x,
  flows = c("full", "destination", "attractiveness"),
  probs = seq(0, 1, 0.25),
  normalisation = c("none", "origin", "full"),
  ...
)
}
\arguments{
\item{x}{a collection of spatial interaction models, a \code{sim_list}}

\item{flows}{\code{"full"} (default),  \code{"destination"} or \code{"attractiveness"}, see
details.}

\item{probs}{numeric vector of probabilities with values in \eqn{[0,1]}.}

\item{normalisation}{when \code{flows="full"}, the flows are used as is, that
without normalisation (\code{normalisation="none"}, default case) or they can be
normalised prior the calculation of the quantiles, either to sum to one
for each origin location (\code{normalisation="origin"}) or to sum to one globally
(\code{normalisation="full"}). This is useful for \code{\link[=autoplot.sim_list]{autoplot.sim_list()}}.}

\item{...}{additional parameters, not used currently}
}
\value{
a date frame, see details
}
\description{
The function computes the specified quantiles for individual or aggregated
flows in a collection of spatial interaction models.
}
\details{
The exact behaviour depends on the value of \code{flows}. In all cases, the
function returns a data frame. The data frame has one column per quantile,
named after the quantile using a percentage based named, as in the default
\code{\link[stats:quantile]{stats::quantile()}}. For a graphical representation of those quantiles, see
\code{\link[=autoplot.sim_list]{autoplot.sim_list()}}.
\itemize{
\item if \code{flows="full"}: this is the default case in which the function
computes for each pair of origin \eqn{o} and destination \eqn{d} locations
the quantiles of the distribution of the flow from \eqn{o} to \eqn{d} in the
collection of models (the flows maybe normalised before quantile
calculations, depending on the value of \code{normalisation}). In addition to the
quantiles, the data frame has two columns:
\itemize{
\item \code{origin_idx}: identifies the origin location by its index from 1 to the number
of origin locations;
\item \code{destination_idx}: identifies the destination location by its index from 1
to the number of destination locations.
}
\item if \code{flows="destination"}, the function computes quantiles for each
destination \eqn{d} location of the distribution of its incoming flow
(\code{\link[=destination_flow]{destination_flow()}}) in the collection of models. In addition to the
quantiles, the data frame has one column \code{destination} that identifies the
destination location by its index from 1 to the number of destination
locations.
\item if \code{flows="attractiveness"}, the function computes quantiles for each
destination \eqn{d} location of the distribution of its attractiveness
(\code{\link[=attractiveness]{attractiveness()}}) in the collection of models. In addition to the
quantiles, the data frame has one column \code{destination} that identifies the
destination location by its index from 1 to the number of destination
locations.
}
}
\examples{
distances <- french_cities_distances[1:10, 1:10] / 1000 ## convert to km
production <- rep(1, 10)
attractiveness <- log(french_cities$area[1:10])
all_flows <- grid_blvim(distances, production, seq(1.05, 1.45, by = 0.1),
  seq(1, 3, by = 0.5) / 400,
  attractiveness,
  bipartite = FALSE,
  epsilon = 0.1, iter_max = 1000
)
head(quantile(all_flows))
head(quantile(all_flows, flows = "destination"))
head(quantile(all_flows,
  flows = "attractiveness",
  probs = c(0.1, 0.3, 0.6, 0.9)
))
}
\seealso{
\code{\link[=fortify.sim_list]{fortify.sim_list()}} \code{\link[=autoplot.sim_list]{autoplot.sim_list()}}
}
