% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rockquality.R
\docType{data}
\name{rockquality}
\alias{rockquality}
\title{rockquality Bayesian Network}
\format{
A discrete Bayesian network  to predict the probability for the classification of surrounding rock quality of tunnel with incomplete data. Probabilities were given within the referenced paper. The vertices are:
\describe{
\item{BQ}{Basic quality of rock mass  (Num1, Num2, Num3, Num4, Num5);}
\item{Groundwater}{(DryWet, MoistDripping, RainlikeDripping, TubularGushing);}
\item{InSituStress}{(Low, Medium, High, ExtremelyHigh);}
\item{RockHardness}{(Hard, SlightlyHard, SlightlySoft, Soft, ExtremelySoft);}
\item{RockMassIntegrity}{(Complete, SlightlyComplete, SlightlyBroken, Broken, ExtremelyBroken);}
\item{RockMassStructure}{(State1, State2, State3, State4, State5);}
\item{RockQuality}{(I, II, III, IV, V);}
\item{StructuralPlaneIntegrity}{(Good, Ordinary, Bad, VeryBad);}
\item{WeatheringDegree}{(Fresh, Slight, Medium, Severe, Extreme).}
}
}
\value{
An object of class \code{bn.fit}. Refer to the documentation of \code{bnlearn} for details.
}
\description{
A probability prediction method for the classification of surrounding rock quality of tunnels with incomplete data using Bayesian networks.
}
\references{
Ma, J., Li, T., Li, X., Zhou, S., Ma, C., Wei, D., & Dai, K. (2022). A probability prediction method for the classification of surrounding rock quality of tunnels with incomplete data using Bayesian networks. Scientific Reports, 12(1), 19846.
}
\keyword{ReverseTree}
