% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fp_utilities.R
\name{condition_numbers}
\alias{condition_numbers}
\alias{summation_condition_number}
\alias{evaluation_condition_number}
\title{Condition Numbers}
\usage{
summation_condition_number(x = 0, kahan = TRUE)

evaluation_condition_number(f, x)
}
\arguments{
\item{x}{A numeric value.}

\item{kahan}{A logical value indicating whether to use Kahan summation.}

\item{f}{A function for which to compute the condition number.}
}
\value{
For \code{summation_condition_number}, an object with methods to compute the condition number, sum, L1 norm, and to add or subtract values. For \code{evaluation_condition_number}, a numeric value representing the condition number of the function evaluation at \code{x}.
}
\description{
Functions to compute condition numbers for summation operations.
}
\examples{
# Create a summation condition number object
scn <- summation_condition_number(kahan = TRUE)
# Add some values
scn$add(1.0)
scn$add(2.0)
scn$add(3.0)
# Compute sum, condition number, and L1 norm
print(scn$sum())
print(scn$condition_number())
print(scn$l1_norm())
# Compute evaluation condition number for a function
f <- function(x) { x^2 + 3*x + 2 }
print(evaluation_condition_number(f, 1.0))
}
