% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bp_sleep_metrics.R
\name{bp_sleep_metrics}
\alias{bp_sleep_metrics}
\title{Nocturnal Blood Pressure Metrics}
\usage{
bp_sleep_metrics(data, subj = NULL)
}
\arguments{
\item{data}{User-supplied data set containing blood pressure data. Must
contain a Systolic blood pressure (\code{SBP}), Diastolic blood pressure (\code{DBP})
as well as \code{ID}, \code{WAKE}, and \code{DATE_TIME} columns.}

\item{subj}{Optional argument. Allows the user to specify and subset specific subjects
from the \code{ID} column of the supplied data set. The \code{subj} argument can be a single
value or a vector of elements. The input type should be character, but the function will
comply with integers so long as they are all present in the \code{ID} column of the data.}
}
\value{
The function outputs a list containing 4 tibble objects corresponding to the following tables:
\item{[[1]]}{Counts of how many BP measurements were observed overall (\code{N_total}),
total number of readings during sleep (\code{N_sleep}),
total number of readings during wake (\code{N_wake}),
number of unique hours recorded during the sleep period (\code{HRS_sleep}), and
number of unique hours recorded during the wake period (\code{HRS_wake}) for each subject ID and grouping variable}
\item{[[2]]}{Summary statistics for systolic BP measurements (SBP): mean SBP value over Sleep and Wake, sd SBP value
over Sleep and Wake, mean SBP value over presleep period (evening in Kario et al. (2003)), mean SBP value over prewake period,
mean SBP value over postwake period (morning in Kario et al. (2003)), mean SBP value over 3 reading centered at the lowest SBP
value during sleep}
\item{[[3]]}{Summary statistics for diastolic BP measurements (DBP), same as for SBP}
\item{[[4]]}{BP metrics associated with sleep as defined above, separately for SBP and DBP}
}
\description{
The \code{bp_sleep_metrics} function serves to calculate nocturnal metrics
from relevant medical literature.
}
\details{
NOTE: Any reference to "sleep" in the bp package refers to an individual's nocturnal period;
"sleep" is used in an informal sense for intuitive purposes. Technically, from a clinical perspective,
indication of sleep is currently obtained through means of EEG or other highly specialized equipment.
For all intents and purposes, sleep in the context of this package refers to actigraphy-inferred
nocturnal periods of rest.


The calculation of BP metrics related to sleep is based on averages of BP readings from four periods as identified in Kairo et al. (2003):
presleep or evening (2 hours before sleep start),
prewake (2 hours before wake),
postwake or morning (2 hours after wake),
lowest (3 measurements centered at the minimal BP reading over sleep).
The function uses \code{WAKE} column to automatically allocate BP measurements to various periods. The following metrics are defined as a
function of the period averages (separately for SBP and DBP)

\code{dip_calc} = 1 - mean_sleep_BP/mean_wake_BP (dip proportion)

\code{noct_fall} = mean_presleep_BP - mean_lowest_BP (nocturnal fall)

\code{ST_mbps} = mean_postwake_BP - mean_lowest_BP (sleep through morning blood pressure surge)

\code{PW_mbps} = mean_postwake_BP - mean_prewake_BP (prewake morning blood pressure surge)

\code{ME_avg} = (mean_presleep_BP + mean_postwake_BP)/2 (morning-evening average)

\code{ME_diff} = mean_postwake_BP - mean_presleep_BP (morning-evening difference)

\code{wSD} = ( (wake_SD x HRS_wake) + (sleep_SD x HRS_sleep) ) / (HRS_wake + HRS_sleep) (weighted standard deviation)
}
\examples{
hypnos_proc <- process_data(bp_hypnos,
                           sbp = "syst",
                           dbp = "DIAST",
                           date_time = "date.time",
                           id = "id",
                           wake = "wake",
                           visit = "visit",
                           hr = "hr",
                           map = "map",
                           rpp = "rpp",
                           pp = "pp",
                           bp_type = "ABPM")

bp_sleep_metrics(hypnos_proc)

}
\references{
Kario, K., Pickering, T. G., Umeda, Y., Hoshide, S., Hoshide, Y., Morinari, M., ... & Shimada, K. (2003). Morning surge in blood
pressure as a predictor of silent and clinical cerebrovascular disease in elderly hypertensives: a prospective study. Circulation,
107(10), 1401-1406.
}
