% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bp_visuals_tables.R
\name{dow_tod_plots}
\alias{dow_tod_plots}
\title{Blood Pressure Tables in Graphical Format}
\usage{
dow_tod_plots(data, subj = NULL)
}
\arguments{
\item{data}{A processed dataframe resulting from the \code{process_data} function that
contains the \code{SBP}, \code{DBP}, \code{DAY_OF_WEEK}, \code{Time_of_Day}, \code{SBP_Category},
and \code{DBP_Category} columns.}

\item{subj}{Optional argument. Allows the user to specify and subset specific subjects
from the \code{ID} column of the supplied data set. The \code{subj} argument can be a single
value or a vector of elements. The input type should be character, but the function will
comply with integers so long as they are all present in the \code{ID} column of the data.}
}
\value{
A list of four `gtables` that correspond to the tables for Day of Week and
Time of Day broken down by both \code{SBP} and \code{DBP}.
}
\description{
Blood Pressure Tables in Graphical Format
}
\examples{

data("bp_hypnos")
hyp_proc <- process_data(bp_hypnos,
                         bp_type = 'ABPM',
                         sbp = "syst",
                         dbp = "DIAST",
                         date_time = "date.time",
                         id = "id",
                         wake = "wake",
                         visit = "visit",
                         hr = "hr",
                         map = "map",
                         rpp = "rpp",
                         pp = "pp",
                         ToD_int = c(5, 13, 18, 23))

rm(bp_hypnos)

dow_tod_plots_out <- dow_tod_plots(hyp_proc)
grid::grid.draw(
   gridExtra::grid.arrange(dow_tod_plots_out[[1]], dow_tod_plots_out[[2]], ncol = 2)
 )

}
