% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/braidrm.R
\name{braidrm}
\alias{braidrm}
\alias{summary.braidrm}
\alias{print.summary.braidrm}
\alias{print.braidrm}
\alias{braidrm.formula}
\alias{braidrm.default}
\title{BRAID Response Surface Fitting}
\usage{
braidrm(
  formula,
  data,
  model = "kappa2",
  links = NULL,
  weights = NULL,
  start = NULL,
  direction = 0,
  lower = NULL,
  upper = NULL,
  prior = "moderate",
  getCIs = TRUE
)

\method{summary}{braidrm}(object, ...)

\method{print}{summary.braidrm}(x, ...)

\method{print}{braidrm}(x, ...)

\method{braidrm}{formula}(
  formula,
  data,
  model = "kappa2",
  links = NULL,
  weights = NULL,
  start = NULL,
  direction = 0,
  lower = NULL,
  upper = NULL,
  prior = "moderate",
  getCIs = TRUE
)

\method{braidrm}{default}(
  formula,
  data,
  model = "kappa2",
  links = NULL,
  weights = NULL,
  start = NULL,
  direction = 0,
  lower = NULL,
  upper = NULL,
  prior = "moderate",
  getCIs = TRUE
)
}
\arguments{
\item{formula}{Either an object of class \code{formula} such as would be provided
to a modeling function like \code{\link[stats:lm]{stats::lm()}}, or a width-2 numeric array vector
of concentration pairs (including 0 or Inf).  A formula should specify a
single output as a function of two inputs, eg. \code{activity ~ conc1 + conc2}.}

\item{data}{If \code{forumula} is a symbolic formula, a data frame containing the
specified values. If \code{formula} is a numeric array of concentrations, a
numeric vector of response values, the same length as the number of rows of
\code{formula}.}

\item{model, links}{Parameters \code{model} and \code{links} are used to specify which
variant of the BRAID model is fit to data.  Model may be one of the
following character strings: "kappa1", "kappa2", or "kappa3" (see Details),
or a subset of the numbers 1 through 9 specifying which of the nine BRAID
response surface parameters is allowed to vary when fitting.  \code{links} allows
the user to further specify constraints on the three BRAID maximal effect
parameters (see Details for more).  If \code{model} is one of the supported
character strings, the parameter \code{links} will be ignored.}

\item{weights}{A vector of weights (between 0 and 1) the same length as
the data which determines the weight with which each measurement
will impact the the sum of squared errors.  Weights will be multiplied by
errors \emph{before} squaring.  If \code{NULL} (the default) all weights will be set
to 1. Can be a numeric vector, or the name of a column in \code{data} if \code{formula}
is a symbolic formula}

\item{start}{A BRAID parameter vector specifying the first guess where the
non-linear optimization should begin.  May be a length 7, 8, or 9 vector,
though a full length vector is always preferable.  If \code{NULL} (the default),
it will be estimated from the data.}

\item{direction}{Determines the possible directionality of the BRAID
model.  If 0 (the default) no additional constraints are placed on the
parameters.  If greater than 0, the fitting will require that the maximal
effects are all \emph{greater} than or equal to the minimal effect.  If less
than 0, the fitting will require that all maximal effect is \emph{less} than or
equal to the minimal effect.}

\item{lower}{A numeric vector of lower bounds on the fitted parameter values.
May be the same length as the number of fitted parameters, or a full,
length-9 vector. Missing or unspecified lower bounds may be included as \code{NA}
or \code{Inf}; if unspecified, lower bounds on the first five parameters (IDMA,
IDMB, na, nb, and kappa) will be automatically estimated from the data.
Bounds on the minimal and maximal effect parameters however (E0, EfA, EfB,
and Ef) will be assumed to be infinite unless specified.  A value of \code{NULL},
the default, will be treated as all lower parameter bounds being
unspecified.}

\item{upper}{A numeric vector of upper bounds on the fitted parameter values.
Used in the same way as \code{lower}.}

\item{prior}{A character string specifying the desired Bayesian prior term
for kappa, or an object of class \code{kappaPrior} genererated by the function
\code{\link[=kappaPrior]{kappaPrior()}}.  Allowed strings are "mild", "moderate" (the default),
"high", or "none".  If a string is given, the kappa prior object will be
estimated from the data using an initial ten-parameter fit to approximate
measurement noise.}

\item{getCIs}{Should bootstrapped confidence intervals be estimated and
added to the BRAID fit object. Default value is \code{TRUE}.}

\item{object}{An object of class \code{braidrm} to be summarized}

\item{...}{Further arguments passed to or from other methods.}

\item{x}{An object of class \code{braidrm} or \code{summary.braidrm} to be printed}
}
\value{
An object of class \code{braidrm} containing the following elements:
\itemize{
\item \code{concs}: A width-two array of the concentration pairs fit by the model
\item \code{act}: A vector of responses fit by the model
\item \code{weights}: The vector of weights (the same length as \code{act}) specifying
the relative weight of each measurement
\item \code{coefficients}: A full length-9 named BRAID parameter vector representing
the best fit BRAID surface for the data
\item \code{fitted.values}: A vector of responses (the same length of \code{act}) given by
the best fit response surface as a function of the concentrations in \code{concs}
\item \code{residuals}: The fitting errors of the best fit model, equal to the
\code{fitted.values} subtracted from \code{act}
\code{scenario}: A character string specifying one of 32 distinct fitting
scenarios determined from the parameters \code{model}, \code{links}, and \code{start}. Used
in bootstrapping confidence intervals
\item \code{model}: The model vector (a subset of values between 1 and 9) specifying
which BRAID parameters were varying freely in the fit
\item \code{start}: The length-9 starting BRAID parameter vector used in non-linear
optimization
\item \code{direction}: Like the input parameter, a value of -1, 0, or 1 specifying
the constraint on the directionality of the fitted surface
\item \code{pbounds}: A 2-by-k array of values specifying the lower and upper bounds
of all varying parameters (where k is the number of free parameters).
\item \code{kweight}: A numeric value summarizing the relative Bayesian influence of
the BRAID parameter kappa on optimized objective function.
}

Fit objects with bootstrapped confidence intervals include several additional
elements derived from that; see \code{\link[=calcBraidBootstrap]{calcBraidBootstrap()}} for details.
}
\description{
Fits a BRAID response surface model to data.
}
\details{
One of the hairiest and most confusing aspects of fitting a combined
response surface model is handling the relationships between maximal effects.
Unlike a simple dose response model such as those fit in \code{basicdrm} in which
all parameters can be treated as fairly independent, response surface models
are often considered with constraints that cannot be expressed as simply one
parameter being fixed a particular value.  Many response surface models
assume that the two drugs in combination (and the overall combination) share
a single common maximal effect; others might assume that the maximal effects
of the two drugs should differ but that the overall maximal effect must be
equal to one of these; still others may wish to fit with no constraints on
maximal effect at all beyond guaranteeing that they lie above a fixed
minimal effect.  All these approaches are valid, and creating a functional
interface to support them all is a challenge. The parameters given here
represent our best effort to balance ease-of-use with flexibility.

The primary interface for model selection and customization is the paired
paramters \code{model} and \code{links}.  For the first six parameters of the BRAID
surface, \code{model} is the only relevant control, and operates much as it would
in any fitting function.  If a given parameter (say IDMB) is included in
\code{model} (as index 2) then it will vary freely within the provided bounds to
best fit the data.  If it is not, the value will be fixed at the value given
in \code{start} (or if \code{start} is \code{NULL}, estimated from the data), and will
remain fixed at that value in the best fit surface.

Parameters EfA, EfB, and Ef (the maximal effect parameters) require slightly
more care. Relationships between these values is represented by the \code{links}
parameter, which can take on one of the following five values:
\itemize{
\item "AB": Indicating that the overall Ef parameter is the driver, both EfA and
EfB are constrained to be equal to Ef, whatever its value.  Can be used
when indices 7 and 8 (EfA and EfB) are absent from \code{model}, but index 9 (Ef)
is present
\item "F": Indicating instead that the individual parameters EfA and EfB are
the drivers, and EfA is constrained to be equal to larger magnitude of the
two. Can be used when indices 7 and 8 are present \code{model}, but index 9 is
absent
\item "A": Specifies that the overall maximal effect is equal to that of the
first trug (and consequentially that the effect of drug A must be of greater
or equal magnitude to that of drug B).  Can be used when index 7 is
absent in \code{model} and index 9 is present; index 8 may be present or absent
\item "B": Specifies that the overall maximal effect is equal to that of the
second drug.  Can be used when index 8 is  absent in \code{model} and index 9 is
present; index 7 may be present or absent
\item "" (the empty string): Indicates no equality between maximal effects.
Parameters that are present in \code{model} vary freely in fitting, those that
are absent are fixed at constant values.
}

For example, if the maximal effects \emph{should} be fit, but should be
constrained to be all equal, then it is the parameter Ef that varies freely
in the fitting; the fact that EfA and EfB are always equal to this value is
represented by setting the \code{links} parameter to "AB".  Contrast this with the
(admittedly much less common) scenario in which the \code{links} parameter is set
to the empty string "", representing no link between maximal effects. In this
case the parameter Ef will indeed vary freely in the fitting, but EfA and
EfB will instead always be held at the constant initial values in the
starting parameter vector.  On the other hand, if we were to assume that the
two individual maximum effect parameters can vary independently, but that
the overall maximal effect should be equal to the larger of the two, then
indices 7 and 8 (representing EfA and EfB) would be included in \code{model};
index 9 (representing Ef) would be excluded, and the \code{links} parameter would
be set to "F" indicating that Ef is tied to the larger of the two.

Note also that the default value for \code{links} is \emph{not} the empty string, but
instead \code{NULL}.  By default the value of \code{links} will be guessed from the
model vector, based on the scenarios that we have encountered most often.
If \code{model} inclues Ef (index 9) but not EfA or EfB (indices 7 and 8), \code{links}
is assumed to be "F"; if EfA and EfB are present but not Ef, \code{links} is set
to "AB". In the vast majority of cases, you will not need to specify this
parameter yourself.  This is especially true when \code{model} is specified with
one of the model strings, in which any provided value for \code{links} will be
discarded and replaced witht the following preset models:
\itemize{
\item kappa1: Model vector includes (1, 2, 3, 4, 5, 6, 9) and \code{links} is set to
"AB"
\item kappa2: Model vector includes (1, 2, 3, 4, 5, 6, 7, 8) and \code{links} is set
to "F"
\item kappa3: Model vector includes (1, 2, 3, 4, 5, 6, 7, 8, 9) and \code{links} is
set to the empty string
}
}
\examples{
bfit1 <- braidrm(measure ~ concA + concB, additiveExample)
summary(bfit1)

bfit2 <- braidrm(measure ~ concA + concB, synergisticExample,
                 model = c(1,2,3,4,5,6,9),
                 lower = c(NA,NA,NA,NA,NA,0,0),
                 prior = "none",
                 getCIs = FALSE)
summary(bfit2)
}
