% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ursaModel.R
\name{evalUrsaModel}
\alias{evalUrsaModel}
\title{Evaluate URSA response surface model}
\usage{
evalUrsaModel(DA, DB, upar)
}
\arguments{
\item{DA}{A vector of concentrations of drug A in a combination (values 0
and \code{Inf} are permitted). Must be length 1 or the same length as \code{DB}.}

\item{DB}{A vector of concentrations of drug B in a combination (values 0
and \code{Inf} are permitted). Must be length 1 or the same length as \code{DA}.}

\item{upar}{A length seven URSA response surface parameter vector (see
Details)}
}
\value{
A numeric vector the same length as \code{DA}
and/or \code{DB} with the predicted URSA response surface values.
}
\description{
Numerically estimates the universal response surface approach (URSA) model
for the given data and parameters (Greco, Park, and Rustum 1990).
}
\details{
The URSA model is described by the following seven values
\itemize{
\item IDMA: The dose of median effect of drug A, also called the EC50
\item IDMB: The dose of median effect of drug B
\item na: The Hill slope, or sigmoidicity, of drug A
\item nb: The Hill slope of drug B
\item alpha: The URSA interaction parameter, indicating additivity (alpha = 0),
antagonism (alpha < 0), or synergy (alpha > 0)
\item E0: The minimal effect, the effect observed when neither drug is present
\item Ef: The maximal effect of the drugs, theoretically observed when
either drug is present at infinite concentration
}
}
\examples{
concentrations <- c(0, 2^(-3:3))
surface <- data.frame(
    concA = rep(concentrations,each=length(concentrations)),
    concB = rep(concentrations,times=length(concentrations))
)

surface$uadditive <- evalUrsaModel(
    surface$concA,
    surface$concB,
    c(1, 1, 3, 3, 0, 0, 100)
)

surface$usynergy <- evalUrsaModel(
    surface$concA,
    surface$concB,
    c(1, 1, 3, 3, 5, 0, 80)
)

surface$uantagonism <- evalUrsaModel(
    surface$concA,
    surface$concB,
    c(1, 1, 3, 3, -0.5, 0, 100)
)

head(surface)
}
\references{
Greco, William R, Hyoung Sook Park, and Youcef M Rustum. 1990.
“Application of a New Approach for the Quantitation of Drug Synergism to
the Combination of Cis-Diamminedichloroplatinum and
1-b-d-Arabinofuranosylcytosine.” \emph{Cancer Research} \strong{50} (17): 5318–27.
}
