% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/utils_matrix.R
\name{Inverse}
\alias{Inverse}
\alias{inv}
\alias{inv.matrix}
\alias{inv.array}
\alias{inv.qr}
\alias{inv.list}
\alias{pinv}
\title{Calculate the inverse of the cross product of a design matrix}
\usage{
inv(x, ...)

\method{inv}{matrix}(x, y = NULL, transpose = FALSE, ...)

\method{inv}{array}(x, y = NULL, transpose = FALSE, ...)

\method{inv}{qr}(x, p = x$rank, ...)

\method{inv}{list}(
  x,
  p = x[[1L]]$rank,
  r = length(x),
  vnames = dimnames(x[[1L]]$qr)[[2L]],
  nms = names(x),
  ...
)

pinv(x)
}
\arguments{
\item{x}{A numeric matrix or array, a \code{qr} object, or a list of
\code{qr} objects}

\item{...}{Unused}

\item{y}{A numeric matrix or vector (for the \code{matrix} and \code{array}
methods). If supplied, this will be multiplied by \code{x} before the
inverse is calculated. Default: \code{NULL}}

\item{transpose}{Logical. If \code{FALSE} (the default), take the cross
product of the arguments. If \code{TRUE}, use \code{\link{tcrossprod}}}

\item{p}{The rank of the original matrix}

\item{r}{The number of design matrices; i.e., the length of the input list}

\item{vnames}{Character vector of the design matrix's variable names}

\item{nms}{The region names; i.e., the names of the input list}
}
\value{
A numeric matrix or array

\code{pinv} returns the input matrix's pseudoinverse
}
\description{
\code{inv} is a \code{S3} generic that calculates the inverse of the cross
product of a design matrix, also referred to as the \dQuote{unscaled
covariance matrix}.

\code{pinv} calculates \eqn{M^{+} = (M^T M)^{-1} M^T} for full (column) rank
matrices. However, it does not verify the matrix's rank.
}
\details{
If \code{x} is a matrix, the Cholesky decomposition of the cross product is
calculated (or using \code{\link{tcrossprod}} if \code{transpose=TRUE}), and
the inverse is calculated from that result. That is,
\deqn{inv(X) = (X^T X)^{-1}}
\deqn{inv(X, transpose=TRUE) = (X X^T)^{-1}}
\deqn{inv(X, y) = (X^T y)^{-1}}

If \code{x} is a 3-dimensional array, then the inverse will be calculated for
each matrix along the 3rd dimension, with the same input arguments for each.

Finally, there is a method for objects with class \code{qr}, and lists of QR
decomposition objects.
}
\note{
These methods should only be used on \emph{full-rank} matrices, as
there is no error checking being performed.
}
