% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{mean_distance_wt}
\alias{mean_distance_wt}
\title{Calculate weighted shortest path lengths}
\usage{
mean_distance_wt(
  g,
  level = c("graph", "vertex"),
  weights = NULL,
  xfm = FALSE,
  xfm.type = NULL,
  D = NULL
)
}
\arguments{
\item{g}{An \code{igraph} graph object}

\item{level}{Character string indicating whether to calculate vertex- or
graph-level shortest path length. Default: \code{'graph'}}

\item{weights}{Numeric vector of edge weights; if \code{NULL} (the default),
and if the graph has edge attribute \code{weight}, then that will be used.
To avoid using weights, this should be \code{NA}.}

\item{xfm}{Logical indicating whether to transform the edge weights. Default:
\code{FALSE}}

\item{xfm.type}{Character string specifying how to transform the weights.
Default: \code{1/w}}

\item{D}{Numeric matrix; the graph's \dQuote{distance matrix}}
}
\value{
Numeric vector (if \code{level='vertex'}) of each vertex's shortest
  path length, or a single number for the graph-level average
}
\description{
Calculate graph or vertex average shortest path lengths. For vertices, this
is just the row means of the distance matrix. For the graph-level, it is the
overall mean of the distance matrix.
}
\details{
By default, edge weights are not transformed (e.g., inverted). However, if
set to \code{TRUE}, then the input graph must have a graph-level attribute
called \code{'xfm.type'} or you must supply a value in the function call. If
you supply a distance matrix (the \code{D} argument), it is not necessary to
transform edge weights, as it is assumed the the distance matrix was
calculated from a graph with transformed edge weights already.
}
