% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convo_update_read.R
\name{bs_update_read}
\alias{bs_update_read}
\title{Mark a conversation (optionally up to a specific message) as read}
\usage{
bs_update_read(
  convo_id,
  message_id = NULL,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{convo_id}{Character, length 1. ID of the conversation to get.}

\item{message_id}{Character, optional. Message ID up to which to mark as read.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} or a \code{list} if \code{clean = FALSE}
}
\description{
Mark a conversation (optionally up to a specific message) as read
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/chat/bsky/convo/updateRead.json}{chat.bsky.convo.updateRead.json (2025-05-16)}
}

\section{Function introduced}{

\code{v0.4.0} (2025-05-16)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) withAutoprint(\{ # examplesIf}
bs_update_read(convo_id = '3ku7w6h4vog2d')
\dontshow{\}) # examplesIf}
}
\concept{chat}
