% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buttons.R
\name{bind_task_button}
\alias{bind_task_button}
\alias{bind_task_button.default}
\alias{bind_task_button.ExtendedTask}
\title{Bind \code{input_task_button} to \code{ExtendedTask}}
\usage{
bind_task_button(target, task_button_id, ...)

\method{bind_task_button}{default}(target, task_button_id, ...)

\method{bind_task_button}{ExtendedTask}(target, task_button_id, ..., session = get_current_session())
}
\arguments{
\item{target}{The target object (i.e. \code{ExtendedTask}).}

\item{task_button_id}{A string matching the \code{id} argument passed to the
corresponding \code{\link[=input_task_button]{input_task_button()}} call.}

\item{...}{Further arguments passed to other methods.}

\item{session}{A Shiny session object (the default should almost always be
used).}
}
\value{
The \code{target} object that was passed in.
}
\description{
Sets up a \link[shiny:ExtendedTask]{shiny::ExtendedTask} to relay its state to an existing
\code{\link[=input_task_button]{input_task_button()}}, so the task button stays in its "busy" state for as
long as the extended task is running.

Note that \code{bind_task_button} does \emph{not} automatically cause button presses to
invoke the extended task; you still need to use \code{\link[shiny:bindEvent]{shiny::bindEvent()}} (or
\code{\link[shiny:observeEvent]{shiny::observeEvent()}}) to cause the button press to trigger an invocation,
as in the example below.

\code{bind_task_button} cannot be used to bind one task button to multiple
\code{ExtendedTask} objects; if you attempt to do so, any bound \code{ExtendedTask}
that completes will cause the button to return to "ready" state.
}
\examples{
\dontshow{if (rlang::is_interactive()) withAutoprint(\{ # examplesIf}

library(shiny)
library(bslib)
library(future)
plan(multisession)

ui <- page_sidebar(
  sidebar = sidebar(
    input_task_button("recalc", "Recalculate")
  ),
  textOutput("outval")
)

server <- function(input, output) {
  rand_task <- ExtendedTask$new(function() {
    future({
      # Slow operation goes here
      Sys.sleep(2)
      runif(1)
    }, seed = TRUE)
  })

  # Make button state reflect task.
  # If using R >=4.1, you can do this instead:
  # rand_task <- ExtendedTask$new(...) |> bind_task_button("recalc")
  bind_task_button(rand_task, "recalc")

  observeEvent(input$recalc, {
    rand_task$invoke()
  })

  output$outval <- renderText({
    rand_task$result()
  })
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
