% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-code-editor.R
\name{input_code_editor}
\alias{input_code_editor}
\alias{update_code_editor}
\title{Code editor input}
\usage{
input_code_editor(
  id,
  label = NULL,
  value = "",
  ...,
  language = "plain",
  height = "auto",
  width = "100\%",
  theme_light = "github-light",
  theme_dark = "github-dark",
  read_only = FALSE,
  line_numbers = NULL,
  word_wrap = NULL,
  tab_size = 2,
  indentation = c("space", "tab"),
  fill = TRUE
)

update_code_editor(
  id,
  ...,
  value = NULL,
  label = NULL,
  language = NULL,
  theme_light = NULL,
  theme_dark = NULL,
  read_only = NULL,
  line_numbers = NULL,
  word_wrap = NULL,
  tab_size = NULL,
  indentation = NULL,
  session = get_current_session()
)
}
\arguments{
\item{id}{Input ID. Access the current value with \verb{input$<id>}.}

\item{label}{Display label for the input. Default is \code{NULL} for no label.}

\item{value}{Code content. Default is an empty string.}

\item{...}{Named arguments, e.g. \code{class} and \code{style}, that will be added to
the outer container of the input.}

\item{language}{Programming language for syntax highlighting. Supported
languages include \code{"r"}, \code{"python"}, \code{"julia"}, \code{"sql"}, \code{"javascript"},
\code{"typescript"}, \code{"html"}, \code{"css"}, \code{"scss"}, \code{"sass"}, \code{"json"},
\code{"markdown"}, \code{"yaml"}, \code{"xml"}, \code{"toml"}, \code{"ini"}, \code{"bash"}, \code{"docker"},
\code{"latex"}, \code{"cpp"}, \code{"rust"}, \code{"diff"}, and \code{"plain"}. Default is
\code{"plain"}.}

\item{height}{CSS height of the editor. Default is \code{"300px"}.}

\item{width}{CSS width of the editor. Default is \code{"100\%"}.}

\item{theme_light, theme_dark}{Theme to use in light or dark mode. Defaults to
\code{"github-light"} and \code{"github-dark"}, respectively. See the Theme section
for more details.}

\item{read_only}{Whether the editor should be read-only. Default is \code{FALSE}.}

\item{line_numbers}{Whether to show line numbers. Default is \code{TRUE}, except
for markdown and plain text.}

\item{word_wrap}{Whether to wrap long lines, by default disabled when
\code{line_numbers} is \code{FALSE}.}

\item{tab_size}{Number of spaces per tab. Default is \code{2}.}

\item{indentation}{Type of indentation: \code{"space"} or \code{"tab"}. Default is
\code{"space"}.}

\item{fill}{Whether or not to allow the card to grow/shrink to fit a
fillable container with an opinionated height (e.g., \code{page_fillable()}).}

\item{session}{a shiny session object (the default should almost always be
used).}
}
\value{
An HTML tag object that can be included in a Shiny UI.
}
\description{
Creates an interactive light-weight code editor input that can be used in
Shiny applications. The editor provides syntax highlighting, line numbers,
and other basic code editing features powered by Prism Code Editor. For a
complete example, run \code{shiny::runExample("code-editor", package = "bslib")}.

The editor value is not sent to R on every keystroke. Instead, updates are
reflected on the server when the user moves away from the editor or when they
press \code{Ctrl/Cmd} + \code{Enter}.

Note that this input is not designed for editing or rendering large files.
Displaying files with 1,000 lines or more may lead to performance issues.
}
\section{Keyboard shortcuts}{

The editor supports the following keyboard shortcuts:
\itemize{
\item \code{Ctrl/Cmd+Enter}: Submit the current code to R
\item \code{Ctrl/Cmd+Z}: Undo
\item \code{Ctrl/Cmd+Shift+Z}: Redo
\item \code{Tab}: Indent selection
\item \code{Shift+Tab}: Dedent selection
}
}

\section{Themes}{

The editor automatically switches between \code{theme_light} and \code{theme_dark}
when used with \code{\link[=input_dark_mode]{input_dark_mode()}}. Otherwise, the editor will use
\code{theme_light} by default.

A variety of themes are available for use. The full list of bundled themes
is: \code{"atom-one-dark"}, \code{"dracula"}, \code{"github-dark-dimmed"}, \code{"github-dark"}, \code{"github-light"}, \code{"night-owl-light"}, \code{"night-owl"}, \code{"prism-okaidia"}, \code{"prism-solarized-light"}, \code{"prism-tomorrow"}, \code{"prism-twilight"}, \code{"prism"}, \code{"vs-code-dark"}, \code{"vs-code-light"}.
}

\examples{
\dontshow{if (rlang::is_interactive()) withAutoprint(\{ # examplesIf}
library(shiny)
library(bslib)

ui <- page_fluid(
  input_code_editor(
    "sql_query",
    value = "SELECT * FROM table",
    language = "sql"
  ),
  verbatimTextOutput("code_output")
)

server <- function(input, output, session) {
  output$code_output <- renderPrint({
    input$sql_query
  })
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
\seealso{
Other input controls: 
\code{\link{input_dark_mode}()},
\code{\link{input_switch}()}
}
\concept{input controls}
