% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_openapi.R
\name{bunddev_parameters}
\alias{bunddev_parameters}
\title{List OpenAPI parameters for an API}
\usage{
bunddev_parameters(id, name = NULL, path = NULL, method = NULL)
}
\arguments{
\item{id}{Registry id.}

\item{name}{Optional parameter name to filter.}

\item{path}{Optional endpoint path to filter.}

\item{method}{Optional HTTP method to filter.}
}
\value{
A tibble with parameter metadata.
}
\description{
List OpenAPI parameters for an API
}
\details{
Returns one row per parameter defined in the OpenAPI spec. Enumerations are
stored in a list-column (\code{enum}). Use the filter arguments to narrow down
results to a specific endpoint or parameter name.
}
\examples{
\dontrun{
bunddev_parameters("smard", name = "resolution")
}

}
\seealso{
\code{\link[=bunddev_parameters_for]{bunddev_parameters_for()}} for adapter-specific parameters and
\code{\link[=bunddev_parameter_values]{bunddev_parameter_values()}} for enum values.
}
