% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.capr}
\alias{plot.capr}
\title{Plot deviation diagnostics by component count}
\usage{
\method{plot}{capr}(x, ...)
}
\arguments{
\item{x}{A \code{capr} object returned by \code{\link[=capr]{capr()}}.}

\item{...}{Additional arguments passed to \code{\link[graphics:plot.default]{graphics::plot()}} and applied to
both panels (for example, \code{pch}, \code{col}, or axis limits).}
}
\value{
Invisibly returns the numeric vector of log deviation values (one per
component).
}
\description{
For a fitted CAP regression, plots two diagnostics across the first
\eqn{K} components: (1) the negative log-likelihood returned by \code{\link[=capr]{capr()}}
and (2) the log deviation-from-diagonality (DfD) for the loading matrix
formed by the first \eqn{k} directions. Both curves help assess the gain
from adding components.
}
\details{
The DfD criterion for the first \eqn{k} directions \eqn{\Gamma^{(k)}} is
\deqn{\text{DfD}(\Gamma^{(k)}) =
\left(\prod_{i = 1}^{n}
  \nu\!\left(\Gamma^{(k)\top} S_i \Gamma^{(k)} / T_i\right)^{T_i}
\right)^{1 / \sum_i T_i},}
where
\deqn{
\nu(A)=\frac{\det\{\mathrm{diag}(A)\}}{\det(A)}
} for a positive definite matrix \eqn{A}.
The curve shows \eqn{\log \text{DfD}(\Gamma^{(k)})}. A common choice for
\eqn{k} is the last point before a sudden jump in the negative
log-likelihood or log-DfD curve.
}
\examples{
sim <- simu.capr(seed = 123L, n = 120L)
fit <- capr(S = sim$S, X = sim$X, K = 3L)
plot(fit)

}
\seealso{
\code{\link[=log_deviation_from_diagonality]{log_deviation_from_diagonality()}}
}
