% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{rmvn}
\alias{rmvn}
\title{Multivariate normal distribution function}
\usage{
rmvn(n, mean, cor, var = NULL)
}
\arguments{
\item{n}{number of samples}

\item{mean}{matrix with mean values (either a 1xp or nxp matrix)}

\item{cor}{matrix with correlation (either a 1x((p-1)*p/2) or nx((p-1)*p/2)
matrix. The correlation coefficients must be given in the order R(1,2),
R(1,3), ..., R(1,p), R(2,3), ... R(2,p), ... where R(i,j) is the entry in
row i and column j of the correlation matrix.}

\item{var}{Optional covariance matrix (instead of 'cor' argument)}
}
\description{
Draw random samples from multivariate normal distribution with
variance given by a correlation matrix.
}
\examples{
rmvn(10, cor = rep(c(-0.999, 0.999), each = 5))
}
