% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateFisherInfo.R
\name{simulateFisherInfo}
\alias{simulateFisherInfo}
\title{Calculates Fisher Information under different adaptive battery specifications}
\usage{
simulateFisherInfo(catObjs = list(), theta, responses)
}
\arguments{
\item{catObjs}{A list of \code{Cat} objects of the same class.}

\item{theta}{A vector of numerics representing the true value of theta.}

\item{responses}{A dataframe of answer profiles corresponding to the true values of theta.}
}
\value{
The function \code{simulateFisherInfo} returns a dataframe where each \code{Cat} object corresponds to a column and each respondent corresponds to a row.
}
\description{
Takes in a a \code{Cat} object, a set of respondents, and their corresponding \code{theta} values, and calculates the amount of information given an adaptive battery.
}
\details{
The function takes a \code{Cat} object, \code{theta}, and response profiles. 
The user defines the selection type, estimation type, etc. so that the questions can be applied adaptively
These adaptive profiles are then used to calculate the total inforamtion gained for a respondent for all answered
items, conditioned on \code{theta}.
}
\examples{

\dontrun{
# Example takes > 2.5 min to run
# Load Cat object
data(grm_cat)
   
# Simulate respondents
respondents <- plyr::adply(.data = matrix(c(-1, 0, 1)),
                           .margins = 1,
                           .id = NULL,
                           .fun = simulateRespondents, cat = grm_cat, n = 10)

# A stopping rule (here, a common one) is required
grm_cat@lengthThreshold <- 3

# Specify different adaptive inventory procedures
grm_MAP <- grm_EAP <- grm_cat
grm_MAP@estimation <- "MAP"
grm_EAP@estimation <- "EAP"

# List of Cat objects 
grmList <- list(grm_MAP, grm_EAP)

# Results
fisher_inf_results <- simulateFisherInfo(catObjs = grmList,
                              theta = rep(c(-1, 0, 1),
                              each = 10),
                              responses = respondents)
}

}
\seealso{
\code{\link{Cat-class}}, \code{\link{fisherTestInfo}}, \code{\link{selectItem}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery, Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil, Jaerin Kim, Dominique Lockett
}
