% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPriorGroups.R
\name{addPriorGroups}
\alias{addPriorGroups}
\title{Group together latent parameters by prior distribution.}
\usage{
addPriorGroups(drawsDF)
}
\arguments{
\item{drawsDF}{the dataframe created by  \code{dag_numpyro()} where each row represents one draw of MCMC output.  Two columns are expected, \code{param} - the parameter name, \code{value} - the realized value, and a third column, \code{priorGroup}, is appended as an integer grouping parameters by their prior distributions. The data for this third column is stored in an environment called \code{cacheEnv} when the \code{dag_numpyro()} function is called.  Any parameters with the same prior end up in the same prior group; used by \code{dagp_plot()} to group parameters when plotted.}
}
\value{
a tidy dataframe of posterior draws. Useful for passing to \code{dagp_plot()} or for creating plots using \code{ggplot()}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Add a column to a tidy dataframe of draws that groups parameters by their prior distribution.  All parameters with the same prior distribution receive the same index.
}
