% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_combinations.R
\name{analyze_top_combinations}
\alias{analyze_top_combinations}
\title{Analyze Top Operation Combinations}
\usage{
analyze_top_combinations(top_combos, start_state, k)
}
\arguments{
\item{top_combos}{Data frame or data.table with a \code{combination} column
(string of operation digits, e.g., "132")}

\item{start_state}{Integer vector, the initial permutation state}

\item{k}{Integer, parameter for reverse operations}
}
\value{
Data frame with columns V1..Vn, operation, step, combo_number,
nL, nR, nX, theta, phi, omega_conformal
}
\description{
For each combination in a data frame of top results, runs a full cycle
analysis and collects all states with their celestial coordinates into
a single data frame.
}
\examples{
combos <- data.frame(combination = c("13", "23"), stringsAsFactors = FALSE)
# result <- analyze_top_combinations(combos, 1:10, k = 4)
}
