% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cayleyR-package.R
\docType{package}
\name{cayleyR-package}
\alias{cayleyR}
\alias{cayleyR-package}
\title{cayleyR: Cayley Graph Analysis for Permutation Puzzles}
\description{
Implements algorithms for analyzing Cayley graphs of permutation groups, with
a focus on the TopSpin puzzle and similar combinatorial problems. Provides
C++ implementations of core operations via Rcpp, cycle detection, state space
exploration, bidirectional BFS pathfinding, and finding optimal operation
sequences in permutation groups generated by shift and reverse operations.
Optional GPU acceleration via ggmlR Vulkan backend for batch distance
calculations and parallel state transformations.
}
\details{
\subsection{Main Features}{
\itemize{
\item \strong{Basic permutation operations} (C++): cyclic left/right shifts, prefix reversal
\item \strong{Cycle analysis}: find cycles in Cayley graphs with detailed state information
\item \strong{Sequence optimization}: search for operation sequences with maximum cycle length
\item \strong{Bidirectional BFS}: find shortest paths between permutation states
\item \strong{Iterative solver}: find paths between arbitrary states via iterative cycle expansion
\item \strong{Celestial coordinates}: map LRX operation counts to spherical coordinates
\item \strong{GPU acceleration} (optional): Vulkan-based batch computations via ggmlR
\item \strong{Fast processing}: lightweight version for batch testing of combinations
}
}

\subsection{Main Functions}{

\strong{Basic Operations (C++):}
\itemize{
\item \code{\link[=shift_left]{shift_left()}} / \code{\link[=shift_right]{shift_right()}} - Cyclic shifts with coordinate tracking
\item \code{\link[=shift_left_simple]{shift_left_simple()}} / \code{\link[=shift_right_simple]{shift_right_simple()}} - Simple cyclic shifts (no coords)
\item \code{\link[=reverse_prefix]{reverse_prefix()}} / \code{\link[=reverse_prefix_simple]{reverse_prefix_simple()}} - Reverse first k elements
\item \code{\link[=apply_operations]{apply_operations()}} - Apply sequence of operations
}

\strong{Analysis Tools:}
\itemize{
\item \code{\link[=get_reachable_states]{get_reachable_states()}} - Full cycle analysis with state tracking
\item \code{\link[=get_reachable_states_light]{get_reachable_states_light()}} - Lightweight cycle detection
\item \code{\link[=find_best_random_combinations]{find_best_random_combinations()}} - Find best random sequences
\item \code{\link[=analyze_top_combinations]{analyze_top_combinations()}} - Analyze top operation sequences
}

\strong{Pathfinding:}
\itemize{
\item \code{\link[=bidirectional_bfs]{bidirectional_bfs()}} - Bidirectional BFS shortest path
\item \code{\link[=find_path_iterative]{find_path_iterative()}} - Iterative path solver
}

\strong{GPU (optional, requires ggmlR):}
\itemize{
\item \code{\link[=cayley_gpu_available]{cayley_gpu_available()}} / \code{\link[=cayley_gpu_init]{cayley_gpu_init()}} / \code{\link[=cayley_gpu_status]{cayley_gpu_status()}} - GPU management
\item \code{\link[=calculate_differences]{calculate_differences()}} with \code{use_gpu = TRUE} - Manhattan distance on GPU
\item \code{\link[=apply_operations_batch_gpu]{apply_operations_batch_gpu()}} - Batch operations via matrix multiplication
\item \code{\link[=manhattan_distance_matrix_gpu]{manhattan_distance_matrix_gpu()}} - Pairwise distance matrix
}

\strong{Utilities:}
\itemize{
\item \code{\link[=convert_digits]{convert_digits()}} - Parse operation strings
\item \code{\link[=generate_state]{generate_state()}} / \code{\link[=generate_unique_states_df]{generate_unique_states_df()}} - Random state generation
\item \code{\link[=manhattan_distance]{manhattan_distance()}} - Distance between states
\item \code{\link[=convert_LRX_to_celestial]{convert_LRX_to_celestial()}} - Map operations to celestial coordinates
}
}
}
\references{
\itemize{
\item TopSpin puzzle: \url{https://www.jaapsch.net/puzzles/topspin.htm}
\item Cayley graphs: \url{https://en.wikipedia.org/wiki/Cayley_graph}
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/Zabis13/cayleyR}
  \item Report bugs at \url{https://github.com/Zabis13/cayleyR/issues}
}

}
\author{
Yuri Baramykov \href{mailto:lbsbmsu@mail.ru}{lbsbmsu@mail.ru}
}
\keyword{internal}
