% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state_processing.R
\name{check_duplicates}
\alias{check_duplicates}
\title{Find Duplicate States Between Two Tables}
\usage{
check_duplicates(df1, df2)
}
\arguments{
\item{df1}{Data frame (first set of states)}

\item{df2}{Data frame (second set of states)}
}
\value{
Data frame of duplicate states with a \code{source} column, or NULL if none
}
\description{
Identifies states that appear in both tables by comparing V-columns.
Used for finding intersections between forward and backward searches.
}
\examples{
df1 <- data.frame(V1 = c(1, 2), V2 = c(2, 1))
df2 <- data.frame(V1 = c(2, 3), V2 = c(1, 2))
check_duplicates(df1, df2)
}
