% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_ops_doc.R
\name{reverse_prefix}
\alias{reverse_prefix}
\title{Reverse First k Elements (with Coordinates)}
\arguments{
\item{state}{Integer vector representing the current permutation state}

\item{k}{Integer, number of elements to reverse from the beginning}

\item{coords}{Optional list of current celestial coordinates. If NULL,
starts from zero coordinates.}
}
\value{
List with components:
\item{state}{Integer vector with first k elements reversed}
\item{coords}{List of updated celestial coordinates (nL, nR, nX, theta, phi, omega_conformal)}
}
\description{
Reverses the first k elements of the state vector (turnstile operation).
Tracks celestial coordinates (LRX momentum).
}
\examples{
result <- reverse_prefix(1:10, k = 4)
result$state
}
