% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_ops_doc.R
\name{shift_right}
\alias{shift_right}
\title{Shift State Right (with Coordinates)}
\arguments{
\item{state}{Integer vector representing the current permutation state}

\item{coords}{Optional list of current celestial coordinates. If NULL,
starts from zero coordinates.}
}
\value{
List with components:
\item{state}{Integer vector with elements shifted right by one position}
\item{coords}{List of updated celestial coordinates (nL, nR, nX, theta, phi, omega_conformal)}
}
\description{
Performs a cyclic right shift on the state vector, moving the last element
to the front. Tracks celestial coordinates (LRX momentum).
}
\examples{
result <- shift_right(1:5)
result$state
}
