% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateMarkers.R
\name{updateMarkers}
\alias{updateMarkers}
\title{Update cellMarkers object}
\usage{
updateMarkers(
  object = NULL,
  genemeans = NULL,
  groupmeans = NULL,
  add_gene = NULL,
  add_groupgene = NULL,
  remove_gene = NULL,
  remove_groupgene = NULL,
  remove_subclass = NULL,
  remove_group = NULL,
  bulkdata = NULL,
  nsubclass = object$opt$nsubclass,
  ngroup = object$opt$ngroup,
  expfilter = object$opt$expfilter,
  noisefilter = object$opt$noisefilter,
  noisefraction = object$opt$noisefraction,
  verbose = TRUE
)
}
\arguments{
\item{object}{A 'cellMarkers' class object. Either \code{object} or \code{genemeans}
must be specified.}

\item{genemeans}{A matrix of mean gene expression with genes in rows and cell
subclasses in columns.}

\item{groupmeans}{Optional matrix of mean gene expression for overarching
main cell groups (genes in rows, cell groups in columns).}

\item{add_gene}{Character vector of gene markers to add manually to the cell
subclass gene signature.}

\item{add_groupgene}{Character vector of gene markers to add manually to the
cell group gene signature.}

\item{remove_gene}{Character vector of gene markers to manually remove from
the cell subclass gene signature.}

\item{remove_groupgene}{Character vector of gene markers to manually remove
to the cell group gene signature.}

\item{remove_subclass}{Character vector of cell subclasses to remove.}

\item{remove_group}{Optional character vector of cell groups to remove.}

\item{bulkdata}{Optional data matrix containing bulk RNA-Seq data with genes
in rows. This matrix is only used for its rownames, to ensure that cell
markers are selected from genes in the bulk dataset.}

\item{nsubclass}{Number of genes to select for each single cell subclass.
Either a single number or a vector with the number of genes for each
subclass.}

\item{ngroup}{Number of genes to select for each cell group.}

\item{expfilter}{Genes whose maximum mean expression on log2 scale per cell
type are below this value are removed and not considered for the signature.}

\item{noisefilter}{Sets an upper bound for \code{noisefraction} cut-off below
which gene expression is set to 0. Essentially gene expression above this
level must be retained in the signature. Setting this higher can allow more
suppression via \code{noisefraction} and can favour more highly expressed genes.}

\item{noisefraction}{Numeric value. Maximum mean log2 gene expression across
cell types is calculated and values in celltypes below this fraction are
set to 0. Set in conjunction with \code{noisefilter.} Note: if this is set too
high (too close to 1), it can have a deleterious effect on deconvolution.}

\item{verbose}{Logical whether to show messages.}
}
\value{
A list object of S3 class 'cellMarkers'. See \code{\link[=cellMarkers]{cellMarkers()}} for
details. If \code{\link[=gene2symbol]{gene2symbol()}} has been called, an extra list element \code{symbol}
will be present. The list element \code{update} stores the call to
\code{updateMarkers()}.
}
\description{
Updates a 'cellMarkers' gene signature object with new settings without
having to rerun calculation of gene means, which can be slow.
}
\seealso{
\code{\link[=cellMarkers]{cellMarkers()}} \code{\link[=gene2symbol]{gene2symbol()}}
}
\author{
Myles Lewis
}
