% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ck_generate_rkeys.R
\name{ck_generate_rkeys}
\alias{ck_generate_rkeys}
\title{Generate random record keys}
\usage{
ck_generate_rkeys(dat, nr_digits = 8, seed = NULL)
}
\arguments{
\item{dat}{microdata used to generated hash for random seed}

\item{nr_digits}{maximum number of digits in the record keys. The default setting (\code{8}) corresponds
with the default setting of the method in \code{tau-argus}.}

\item{seed}{if not \code{NULL}, a number specifying the initial seed value
for the random number generator. If \code{NULL}, a seed is computed from \code{dat} itself.}
}
\value{
a numeric vector with \code{nrow(dat)} record keys
}
\description{
This function allows to create random record keys from a uniform distribution. If no seed is
specified, a seed value is computed from the input data set to allow for reproducability depending
on the input data set.
}
\examples{
dat <- ck_create_testdata()
dat$rkeys <- ck_generate_rkeys(dat = ck_create_testdata(), nr_digits = 8)
}
