% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_cnt.R
\name{geom_cnt}
\alias{geom_cnt}
\title{Plot centerline with ggplot2}
\usage{
geom_cnt(
  mapping = ggplot2::aes(),
  data = NULL,
  stat = "sf",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  keep = 0.5,
  method = c("voronoi", "straight"),
  simplify = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}. See
\code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}} for details.}

\item{data}{The data to be displayed in this layer. See \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}
for details.}

\item{stat}{The statistical transformation to use on the data for this layer.
See \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}} for details.}

\item{position}{A position adjustment to use on the data for this layer.
See \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}} for details.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
See \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}} for details.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. See \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}} for details.}

\item{keep}{numeric, proportion of points to retain (0.05-5.0; default 0.5).
See Details.}

\item{method}{character, either \code{"voronoi"} (default) or
\code{"straight"}, or just the first letter \code{"v"} or \code{"s"}.
See Details.}

\item{simplify}{logical, if \code{TRUE} (default) then the
centerline will be smoothed with \code{\link[smoothr:smooth_ksmooth]{smoothr::smooth_ksmooth()}}}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{ggplot2::layer()}}. See
\code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}} for details.}
}
\value{
A \code{Layer} ggproto object that can be added to a plot.
}
\description{
Binding for \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}, therefore it supports
only \code{sf} objects.
}
\section{CRS}{


\code{coord_sf()} ensures that all layers use a common CRS. You can
either specify it using the \code{crs} param, or \code{coord_sf()} will
take it from the first layer that defines a CRS.

}

\section{Combining sf layers and regular geoms}{


Most regular geoms, such as \code{\link[ggplot2:geom_point]{geom_point()}}, \code{\link[ggplot2:geom_path]{geom_path()}},
\code{\link[ggplot2:geom_text]{geom_text()}}, \code{\link[ggplot2:geom_polygon]{geom_polygon()}} etc. will work fine with \code{coord_sf()}. However
when using these geoms, two problems arise. First, what CRS should be used
for the x and y coordinates used by these non-sf geoms? The CRS applied to
non-sf geoms is set by the \code{default_crs} parameter, and it defaults to
\code{NULL}, which means positions for non-sf geoms are interpreted as projected
coordinates in the coordinate system set by the \code{crs} parameter. This setting
allows you complete control over where exactly items are placed on the plot
canvas, but it may require some understanding of how projections work and how
to generate data in projected coordinates. As an alternative, you can set
\code{default_crs = sf::st_crs(4326)}, the World Geodetic System 1984 (WGS84).
This means that x and y positions are interpreted as longitude and latitude,
respectively. You can also specify any other valid CRS as the default CRS for
non-sf geoms.

The second problem that arises for non-sf geoms is how straight lines
should be interpreted in projected space when \code{default_crs} is not set to \code{NULL}.
The approach \code{coord_sf()} takes is to break straight lines into small pieces
(i.e., segmentize them) and then transform the pieces into projected coordinates.
For the default setting where x and y are interpreted as longitude and latitude,
this approach means that horizontal lines follow the parallels and vertical lines
follow the meridians. If you need a different approach to handling straight lines,
then you should manually segmentize and project coordinates and generate the plot
in projected coordinates.

}

\examples{
\dontshow{if (requireNamespace("geomtextpath", quietly = TRUE)) withAutoprint(\{ # examplesIf}
\donttest{
library(sf)
library(ggplot2)

lake <-
  sf::st_read(
    system.file("extdata/example.gpkg", package = "centerline"),
    layer = "lake",
    quiet = TRUE
  )

ggplot() +
  geom_sf(data = lake) +
  geom_cnt(
    data = lake,
    keep = 1,
    simplify = TRUE
  ) +
  theme_void()
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=geom_cnt_text]{geom_cnt_text()}}, \code{\link[=geom_cnt_label]{geom_cnt_label()}}, \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}
}
