% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_metrics.R
\name{cfbd_metrics_wepa_players_kicking}
\alias{cfbd_metrics_wepa_players_kicking}
\title{\strong{Get Points Added Above Replacement (PAAR) ratings for kickers}}
\usage{
cfbd_metrics_wepa_players_kicking(year = NULL, team = NULL, conference = NULL)
}
\arguments{
\item{year}{(\emph{Integer} required): Year, 4 digit format (\emph{YYYY})}

\item{team}{(\emph{String} optional): D-I Team}

\item{conference}{(\emph{String} optional): Conference abbreviation - Select a valid FBS conference
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC}
}
\value{
\code{\link[=cfbd_metrics_wepa_players_kicking]{cfbd_metrics_wepa_players_kicking()}} - A data frame with 7 variables:\tabular{ll}{
   col_name \tab types \cr
   year \tab integer \cr
   athlete_id \tab character \cr
   athlete_name \tab character \cr
   team \tab character \cr
   conference \tab character \cr
   paar \tab numeric \cr
   attempts \tab integer \cr
}
}
\description{
\strong{Get Points Added Above Replacement (PAAR) ratings for kickers}
}
\examples{
\donttest{
  try(cfbd_metrics_wepa_players_kicking(year = 2019, team = "TCU"))
}
}
\seealso{
Other CFBD Metrics: 
\code{\link{cfbd_metrics_fg_ep}()},
\code{\link{cfbd_metrics_ppa_games}()},
\code{\link{cfbd_metrics_ppa_players_games}()},
\code{\link{cfbd_metrics_ppa_players_season}()},
\code{\link{cfbd_metrics_ppa_predicted}()},
\code{\link{cfbd_metrics_ppa_teams}()},
\code{\link{cfbd_metrics_wepa_players_passing}()},
\code{\link{cfbd_metrics_wepa_players_rushing}()},
\code{\link{cfbd_metrics_wepa_team_season}()},
\code{\link{cfbd_metrics_wp}()},
\code{\link{cfbd_metrics_wp_pregame}()}
}
\concept{CFBD Metrics}
\keyword{(PAAR)}
\keyword{Above}
\keyword{Added}
\keyword{Points}
\keyword{Replacement}
\keyword{for}
\keyword{kickers}
\keyword{ratings}
